/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer) {
        PsiElement[] scopeRoots;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "execute"));
        }
        SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            return AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer);
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull AllClassesSearch.SearchParameters parameters, @NotNull Processor<PsiClass> processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processAllClassesInGlobalScope"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processAllClassesInGlobalScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processAllClassesInGlobalScope"));
        }
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(parameters.getProject(), scope, arg_0 -> AllClassesSearchExecutor.lambda$processAllClassesInGlobalScope$0(parameters, (Set)names, arg_0));
        ArrayList<String> sorted = new ArrayList<String>((Collection<String>)names);
        Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        return AllClassesSearchExecutor.processClassesByNames(parameters.getProject(), scope, sorted, processor);
    }

    public static boolean processClassesByNames(Project project, GlobalSearchScope scope, Collection<String> names, Processor<PsiClass> processor) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance(project);
        for (String name : names) {
            ProgressIndicatorProvider.checkCanceled();
            for (PsiClass psiClass : DumbService.getInstance(project).runReadActionInSmartMode(() -> cache.getClassesByName(name, scope))) {
                ProgressIndicatorProvider.checkCanceled();
                if (processor.process(psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    public static Project processClassNames(Project project, GlobalSearchScope scope, final Consumer<String> consumer) {
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            PsiShortNamesCache.getInstance(project).processAllClassNames(new Processor<String>(){
                int i;

                @Override
                public boolean process(String s) {
                    if (indicator != null && this.i++ % 512 == 0) {
                        indicator.checkCanceled();
                    }
                    consumer.consume(s);
                    return true;
                }
            }, scope, IdFilter.getProjectIdFilter(project, true));
            return null;
        });
        if (indicator != null) {
            indicator.checkCanceled();
        }
        return project;
    }

    private static boolean processScopeRootForAllClasses(@NotNull PsiElement scopeRoot, final @NotNull Processor<PsiClass> processor) {
        if (scopeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeRoot", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processScopeRootForAllClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processScopeRootForAllClasses"));
        }
        final boolean[] stopped = new boolean[]{false};
        JavaElementVisitor visitor = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process(aClass);
                super.visitClass(aClass);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process(aClass);
                super.visitClass(aClass);
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> {
            if (scopeRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeRoot", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "lambda$processScopeRootForAllClasses$3"));
            }
            scopeRoot.accept(visitor);
        });
        return !stopped[0];
    }

    private static /* synthetic */ void lambda$processAllClassesInGlobalScope$0(@NotNull AllClassesSearch.SearchParameters parameters, Set names, String s) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "lambda$processAllClassesInGlobalScope$0"));
        }
        if (parameters.nameMatches(s)) {
            names.add(s);
        }
    }
}

