/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import org.jetbrains.annotations.NotNull;

public class JobDescriptor {
    @NotNull
    private final String myDisplayName;
    private int myTotalAmount;
    private int myDoneAmount;
    public static final JobDescriptor[] EMPTY_ARRAY = new JobDescriptor[0];

    public JobDescriptor(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/codeInspection/ex/JobDescriptor", "<init>"));
        }
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/JobDescriptor", "getDisplayName"));
        }
        return string;
    }

    public int getTotalAmount() {
        return this.myTotalAmount;
    }

    public void setTotalAmount(int totalAmount) {
        this.myTotalAmount = totalAmount;
        this.myDoneAmount = 0;
    }

    public int getDoneAmount() {
        return this.myDoneAmount;
    }

    public void setDoneAmount(int doneAmount) {
        this.myDoneAmount = doneAmount;
    }

    public float getProgress() {
        float localProgress = this.getTotalAmount() == 0 ? 0.0f : 1.0f * (float)this.getDoneAmount() / (float)this.getTotalAmount();
        return localProgress;
    }
}

