/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class ClearableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("ClearableLazyValue");
    private T myValue;

    @NotNull
    public static <T> ClearableLazyValue<T> create(final Computable<T> computable) {
        ClearableLazyValue clearableLazyValue = new ClearableLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = computable.compute();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ClearableLazyValue$1", "compute"));
                }
                return t;
            }
        };
        if (clearableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ClearableLazyValue", "create"));
        }
        return clearableLazyValue;
    }

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        T t = result;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ClearableLazyValue", "getValue"));
        }
        return t;
    }

    public void drop() {
        this.myValue = null;
    }
}

