/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceCompatibilityConstraint.class);
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        JavaResolveResult resolve;
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            session.registerIncompatibleErrorMessage(session.getPresentableText(this.myT) + " is not a functional interface");
            return false;
        }
        PsiType groundTargetType = this.myExpression.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(classResolveResult);
        if (interfaceMethod == null) {
            session.registerIncompatibleErrorMessage("No valid function type can be found for " + session.getPresentableText(this.myT));
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, classResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(substitutor);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType = substitutor.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters = this.myExpression.getTypeParameters();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this.myExpression);
        if (this.myExpression.isExact()) {
            PsiParameter[] parameters;
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiClass applicableMemberContainingClass = applicableMember.getContainingClass();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, applicableMember, applicableMemberContainingClass, this.myExpression);
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters.length + 1) {
                PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(this.myExpression);
                PsiClass qualifierClass = PsiUtil.resolveClassInType(qualifierType);
                if (qualifierClass != null) {
                    PsiType pType = signature.getParameterTypes()[0];
                    constraints.add(new StrictSubtypingConstraint(session.substituteWithInferenceVariables(qualifierType), pType));
                }
                for (int i2 = 1; i2 < targetParameters.length; ++i2) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters[i2 - 1].getType())), PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[i2], this.myExpression)));
                }
            } else if (targetParameters.length == parameters.length) {
                for (int i3 = 0; i3 < targetParameters.length; ++i3) {
                    constraints.add(new TypeCompatibilityConstraint(session.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters[i3].getType())), PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[i3], this.myExpression)));
                }
            } else {
                session.registerIncompatibleErrorMessage("Incompatible parameter types in method reference expression");
                return false;
            }
            if (!PsiType.VOID.equals(returnType) && returnType != null) {
                PsiType applicableMethodReturnType = null;
                if (applicableMember instanceof PsiMethod) {
                    PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(this.myExpression, (PsiMethod)applicableMember);
                    PsiType psiType = applicableMethodReturnType = getClassReturnType != null ? getClassReturnType : ((PsiMethod)applicableMember).getReturnType();
                }
                if (PsiType.VOID.equals(applicableMethodReturnType)) {
                    session.registerIncompatibleErrorMessage("Incompatible types: expected not void but compile-time declaration for the method reference has void return type");
                    return false;
                }
                if (applicableMethodReturnType == null && (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) && containingClass != null) {
                    applicableMethodReturnType = JavaPsiFacade.getElementFactory(applicableMember.getProject()).createType(containingClass, PsiSubstitutor.EMPTY);
                }
                if (applicableMethodReturnType != null) {
                    applicableMethodReturnType = psiSubstitutor.substitute(applicableMethodReturnType);
                    applicableMethodReturnType = Registry.is("unsound.capture.conversion.java.spec.change") ? applicableMethodReturnType : PsiUtil.captureToplevelWildcards(applicableMethodReturnType, this.myExpression);
                    constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(applicableMethodReturnType)));
                }
            }
            return true;
        }
        for (PsiType paramType : signature.getParameterTypes()) {
            if (session.isProperType(paramType)) continue;
            return false;
        }
        Map<PsiElement, PsiType> map = LambdaUtil.getFunctionalTypeMap();
        PsiType added = map.put(this.myExpression, session.startWithFreshVars(groundTargetType));
        try {
            resolve = this.myExpression.advancedResolve(true);
        }
        finally {
            if (added == null) {
                map.remove(this.myExpression);
            }
        }
        PsiElement element = resolve.getElement();
        if (element == null || resolve instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolve).isApplicable()) {
            session.registerIncompatibleErrorMessage("No compile-time declaration for the method reference is found");
            return false;
        }
        if (PsiType.VOID.equals(returnType) || returnType == null) {
            return true;
        }
        if (element instanceof PsiMethod) {
            PsiType getClassReturnType;
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, method);
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, method, containingClass, this.myExpression);
            PsiType referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : ((getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(this.myExpression, method)) != null ? getClassReturnType : method.getReturnType());
            LOG.assertTrue(referencedMethodReturnType != null, method);
            if (typeParameters.length == 0 && method.getTypeParameters().length > 0) {
                PsiClass interfaceClass = classResolveResult.getElement();
                LOG.assertTrue(interfaceClass != null);
                if (PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(method.getTypeParameters())).booleanValue()) {
                    session.initBounds((PsiElement)this.myExpression, psiSubstitutor, method.getTypeParameters());
                    session.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve, groundTargetType);
                    session.registerReturnTypeConstraints(psiSubstitutor.substitute(referencedMethodReturnType), returnType);
                    return true;
                }
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                session.registerIncompatibleErrorMessage("Incompatible types: expected not void but compile-time declaration for the method reference has void return type");
                return false;
            }
            int idx = 0;
            for (PsiTypeParameter param : method.getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            if (this.myExpression.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, qualifierResolveResult.getSubstitutor())) {
                session.initBounds((PsiElement)this.myExpression, containingClass.getTypeParameters());
            }
            referencedMethodReturnType = psiSubstitutor.substitute(referencedMethodReturnType);
            referencedMethodReturnType = Registry.is("unsound.capture.conversion.java.spec.change") ? referencedMethodReturnType : PsiUtil.captureToplevelWildcards(referencedMethodReturnType, this.myExpression);
            constraints.add(new TypeCompatibilityConstraint(returnType, session.substituteWithInferenceVariables(referencedMethodReturnType)));
        }
        return true;
    }

    public static PsiSubstitutor getSubstitutor(MethodSignature signature, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMember member, @Nullable PsiClass containingClass, PsiMethodReferenceExpression methodReferenceExpression) {
        PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
        if (qContainingClass != null && containingClass != null) {
            if (PsiUtil.isRawSubstitutor(qContainingClass, psiSubstitutor)) {
                if (member instanceof PsiMethod && PsiMethodReferenceUtil.isSecondSearchPossible(signature.getParameterTypes(), qualifierResolveResult, methodReferenceExpression)) {
                    PsiType pType = PsiUtil.captureToplevelWildcards(signature.getParameterTypes()[0], methodReferenceExpression);
                    psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(qContainingClass, pType);
                } else if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor() || member instanceof PsiClass) {
                    PsiResolveHelper helper = JavaPsiFacade.getInstance(methodReferenceExpression.getProject()).getResolveHelper();
                    Object[] paramTypes = member instanceof PsiMethod ? ((PsiMethod)member).getSignature(PsiSubstitutor.EMPTY).getParameterTypes() : PsiType.EMPTY_ARRAY;
                    LOG.assertTrue(paramTypes.length == signature.getParameterTypes().length, "expr: " + methodReferenceExpression + "; " + paramTypes.length + "; " + Arrays.toString(signature.getParameterTypes()));
                    if (Arrays.deepEquals(signature.getParameterTypes(), paramTypes)) {
                        return PsiSubstitutor.EMPTY;
                    }
                    psiSubstitutor = helper.inferTypeArguments(PsiTypesUtil.filterUnusedTypeParameters(qContainingClass.getTypeParameters(), (PsiType[])paramTypes), (PsiType[])paramTypes, signature.getParameterTypes(), PsiUtil.getLanguageLevel(methodReferenceExpression));
                } else {
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
            }
            if (qContainingClass.isInheritor(containingClass, true)) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, qContainingClass, psiSubstitutor)) != null);
            }
        }
        return psiSubstitutor;
    }

    public static PsiSubstitutor getParameterizedTypeSubstitutor(PsiClass qContainingClass, @NotNull PsiType pType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass paramClass;
        if (pType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pType", "com/intellij/psi/impl/source/resolve/graphInference/constraints/PsiMethodReferenceCompatibilityConstraint", "getParameterizedTypeSubstitutor"));
        }
        if (pType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)pType).getConjuncts()) {
                PsiClassType.ClassResolveResult resolveResult2 = PsiUtil.resolveGenericsClassInType(type);
                if (!InheritanceUtil.isInheritorOrSelf(resolveResult2.getElement(), qContainingClass, true)) continue;
                return PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(qContainingClass, type);
            }
        } else if (pType instanceof PsiCapturedWildcardType) {
            pType = ((PsiCapturedWildcardType)pType).getUpperBound();
        }
        LOG.assertTrue((paramClass = (resolveResult = PsiUtil.resolveGenericsClassInType(pType)).getElement()) != null, pType.getCanonicalText());
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getClassSubstitutor(qContainingClass, paramClass, resolveResult.getSubstitutor());
        LOG.assertTrue(psiSubstitutor != null);
        return psiSubstitutor;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

