/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtilRt {
    private static final String WINDOWS_CHARS = "<>:\"|?*";
    private static final Set<String> WINDOWS_NAMES = ContainerUtilRt.newHashSet("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");
    private static final Charset FS_CHARSET = PathUtilRt.fsCharset();

    @NotNull
    public static String getFileName(@Nullable String path) {
        if (path == null || path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getFileName"));
            }
            return "";
        }
        char c = path.charAt(path.length() - 1);
        int end = c == '/' || c == '\\' ? path.length() - 1 : path.length();
        int start = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1)) + 1;
        String string = path.substring(start, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getFileName"));
        }
        return string;
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtilRt", "getParentPath"));
        }
        if (path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getParentPath"));
            }
            return "";
        }
        int end = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (end == path.length() - 1) {
            end = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1));
        }
        String string = end == -1 ? "" : path.substring(0, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getParentPath"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        String string = PathUtilRt.suggestFileName(text2, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text2, boolean allowDots, boolean allowSpaces) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (!PathUtilRt.isValidFileNameChar(c, Platform.CURRENT, true) || !allowDots && c == '.' || !allowSpaces && Character.isWhitespace(c)) {
                result.append('_');
                continue;
            }
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/PathUtilRt", "isValidFileName"));
        }
        return PathUtilRt.isValidFileName(fileName, Platform.CURRENT, strict, FS_CHARSET);
    }

    public static boolean isValidFileName(@NotNull String name, @NotNull Platform os, boolean strict, @Nullable Charset cs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/PathUtilRt", "isValidFileName"));
        }
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/intellij/util/PathUtilRt", "isValidFileName"));
        }
        if (name.length() == 0 || name.equals(".") || name.equals("..")) {
            return false;
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (PathUtilRt.isValidFileNameChar(name.charAt(i2), os, strict)) continue;
            return false;
        }
        if (os == Platform.WINDOWS && name.length() >= 3 && name.length() <= 4 && WINDOWS_NAMES.contains(name.toUpperCase(Locale.US))) {
            return false;
        }
        return cs == null || cs.canEncode() && cs.newEncoder().canEncode(name);
    }

    private static boolean isValidFileNameChar(char c, Platform os, boolean strict) {
        if (c == '/' || c == '\\') {
            return false;
        }
        if (!(!strict && os != Platform.WINDOWS || c >= ' ' && WINDOWS_CHARS.indexOf(c) < 0)) {
            return false;
        }
        return !strict || c != ';';
    }

    private static Charset fsCharset() {
        String property;
        if (!SystemInfoRt.isWindows && !SystemInfoRt.isMac && (property = System.getProperty("sun.jnu.encoding")) != null) {
            try {
                return Charset.forName(property);
            }
            catch (Exception e) {
                LoggerRt.getInstance(PathUtilRt.class).warn("unknown JNU charset: " + property, e);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        UNIX,
        WINDOWS;

        public static Platform CURRENT;

        static {
            CURRENT = SystemInfoRt.isWindows ? WINDOWS : UNIX;
        }
    }
}

