/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;

public class BlockUtils {
    public static PsiStatement addBefore(PsiStatement anchor, PsiStatement ... newStatements) {
        if (newStatements.length == 0) {
            throw new IllegalArgumentException();
        }
        PsiElement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = parent;
            parent = oldStatement.getParent();
        }
        if (newStatements.length == 1 && oldStatement instanceof PsiEmptyStatement) {
            return (PsiStatement)oldStatement.replace(newStatements[0]);
        }
        PsiElement result = null;
        if (parent instanceof PsiCodeBlock) {
            for (PsiStatement statement : newStatements) {
                result = parent.addBefore(statement, oldStatement);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(anchor.getProject());
            PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", oldStatement);
            PsiCodeBlock codeBlock = newBlockStatement.getCodeBlock();
            for (PsiStatement newStatement : newStatements) {
                codeBlock.add(newStatement);
            }
            codeBlock.add(oldStatement);
            PsiStatement[] statements = ((PsiBlockStatement)oldStatement.replace(newBlockStatement)).getCodeBlock().getStatements();
            result = statements[statements.length - 2];
        }
        return (PsiStatement)result;
    }

    public static PsiStatement addAfter(PsiStatement anchor, PsiStatement newStatement) {
        PsiElement result;
        PsiElement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = parent;
            parent = oldStatement.getParent();
        }
        if (parent instanceof PsiCodeBlock) {
            result = parent.addAfter(newStatement, oldStatement);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(anchor.getProject());
            PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", oldStatement);
            PsiCodeBlock codeBlock = newBlockStatement.getCodeBlock();
            codeBlock.add(oldStatement);
            codeBlock.add(newStatement);
            result = ((PsiBlockStatement)oldStatement.replace(newBlockStatement)).getCodeBlock().getStatements()[1];
        }
        return (PsiStatement)result;
    }
}

