/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideEffectChecker {
    private static final Set<String> ourSideEffectFreeClasses = new THashSet(Arrays.asList(Object.class.getName(), Short.class.getName(), Character.class.getName(), Byte.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), StringBuffer.class.getName(), Boolean.class.getName(), ArrayList.class.getName(), Date.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Hashtable.class.getName(), LinkedHashMap.class.getName(), LinkedHashSet.class.getName(), LinkedList.class.getName(), Stack.class.getName(), TreeMap.class.getName(), TreeSet.class.getName(), Vector.class.getName(), WeakHashMap.class.getName()));

    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/psiutils/SideEffectChecker", "mayHaveSideEffects"));
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor(null);
        exp.accept(visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean mayHaveSideEffects(@NotNull PsiElement element, Predicate<PsiMethodCallExpression> shouldIgnoreCall) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/SideEffectChecker", "mayHaveSideEffects"));
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor(null, shouldIgnoreCall);
        element.accept(visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @NotNull List<PsiElement> sideEffects) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/SideEffectChecker", "checkSideEffects"));
        }
        if (sideEffects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sideEffects", "com/siyeh/ig/psiutils/SideEffectChecker", "checkSideEffects"));
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor(sideEffects);
        element.accept(visitor);
        return visitor.mayHaveSideEffects();
    }

    public static List<PsiExpression> extractSideEffectExpressions(@NotNull PsiExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/SideEffectChecker", "extractSideEffectExpressions"));
        }
        ArrayList<PsiElement> list = new ArrayList<PsiElement>();
        element.accept(new SideEffectsVisitor(list));
        return StreamEx.of(list).select(PsiExpression.class).toList();
    }

    public static boolean mayHaveExceptionalSideEffect(PsiMethod method) {
        if (method.getName().startsWith("assert") || method.getName().startsWith("check")) {
            return true;
        }
        return ControlFlowAnalyzer.getMethodContracts(method).stream().anyMatch(mc -> mc.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    private static boolean isSideEffectFreeConstructor(@NotNull PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/psiutils/SideEffectChecker", "isSideEffectFreeConstructor"));
        }
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        PsiClass aClass = classReference == null ? null : (PsiClass)classReference.resolve();
        String string = qualifiedName = aClass == null ? null : aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName)) {
            return true;
        }
        PsiFile file = aClass.getContainingFile();
        PsiDirectory directory = file.getContainingDirectory();
        PsiPackage classPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance(aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf(aClass, throwableClass, true);
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @Nullable
        private final List<PsiElement> mySideEffects;
        boolean found;
        final Predicate<PsiMethodCallExpression> myIgnoredCallPredicate;

        SideEffectsVisitor(@Nullable List<PsiElement> sideEffects) {
            this(sideEffects, call -> false);
        }

        SideEffectsVisitor(@Nullable List<PsiElement> sideEffects, Predicate<PsiMethodCallExpression> predicate) {
            this.myIgnoredCallPredicate = predicate;
            this.mySideEffects = sideEffects;
        }

        private void addSideEffect(PsiElement element) {
            this.found = true;
            if (this.mySideEffects != null) {
                this.mySideEffects.add(element);
            } else {
                this.stopWalking();
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitAssignmentExpression"));
            }
            this.addSideEffect(expression);
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod method;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitMethodCallExpression"));
            }
            if (!this.myIgnoredCallPredicate.test(expression) && !this.isPure(method = expression.resolveMethod())) {
                this.addSideEffect(expression);
                return;
            }
            super.visitMethodCallExpression(expression);
        }

        protected boolean isPure(PsiMethod method) {
            if (method == null) {
                return false;
            }
            if (PropertyUtil.isSimpleGetter(method)) {
                return true;
            }
            return ControlFlowAnalyzer.isPure(method) && !SideEffectChecker.mayHaveExceptionalSideEffect(method);
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitNewExpression"));
            }
            if (!SideEffectChecker.isSideEffectFreeConstructor(expression)) {
                this.addSideEffect(expression);
                return;
            }
            super.visitNewExpression(expression);
        }

        @Override
        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitPostfixExpression"));
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.addSideEffect(expression);
                return;
            }
            super.visitPostfixExpression(expression);
        }

        @Override
        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitPrefixExpression"));
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.addSideEffect(expression);
                return;
            }
            super.visitPrefixExpression(expression);
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            this.addSideEffect(statement);
        }

        @Override
        public void visitBreakStatement(PsiBreakStatement statement) {
            this.addSideEffect(statement);
        }

        @Override
        public void visitClass(PsiClass aClass) {
        }

        @Override
        public void visitContinueStatement(PsiContinueStatement statement) {
            this.addSideEffect(statement);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            this.addSideEffect(statement);
        }

        @Override
        public void visitThrowStatement(PsiThrowStatement statement) {
            this.addSideEffect(statement);
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public boolean mayHaveSideEffects() {
            return this.found;
        }
    }
}

