/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedStripTrailingSpacesFilter
implements StripTrailingSpacesFilter {
    @NotNull
    private final BitSet myDisabledLinesBitSet;
    @NotNull
    private final Document myDocument;
    private static Logger LOG = Logger.getInstance(PsiBasedStripTrailingSpacesFilter.class);

    protected PsiBasedStripTrailingSpacesFilter(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "<init>"));
        }
        this.myDocument = document;
        this.myDisabledLinesBitSet = new BitSet(document.getLineCount());
    }

    @Override
    public boolean isStripSpacesAllowedForLine(int line) {
        return !this.myDisabledLinesBitSet.get(line);
    }

    protected abstract void process(@NotNull PsiFile var1);

    @Nullable
    public static Language getDocumentLanguage(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "getDocumentLanguage"));
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file = manager.getFile(document);
        if (file != null && file.isValid()) {
            return LanguageUtil.getFileLanguage(file);
        }
        return null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "getPsiFile"));
        }
        if (project != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
            if (documentManager.isCommitted(document)) {
                return documentManager.getCachedPsiFile(document);
            }
        } else {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("No current project is given, trailing spaces will be stripped later (postponed). File: " + (virtualFile != null ? virtualFile.getCanonicalPath() : "undefined"));
        }
        return null;
    }

    protected final void disableRange(@NotNull TextRange range, boolean includeEndLine) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "disableRange"));
        }
        int startLine = this.myDocument.getLineNumber(range.getStartOffset());
        int endLine = this.myDocument.getLineNumber(range.getEndOffset());
        if (includeEndLine) {
            ++endLine;
        }
        this.myDisabledLinesBitSet.set(startLine, endLine);
    }

    public static abstract class Factory
    extends StripTrailingSpacesFilterFactory {
        @Override
        @NotNull
        public final StripTrailingSpacesFilter createFilter(@Nullable Project project, @NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
            }
            Language language = PsiBasedStripTrailingSpacesFilter.getDocumentLanguage(document);
            if (language != null && this.isApplicableTo(language)) {
                PsiFile psiFile = PsiBasedStripTrailingSpacesFilter.getPsiFile(project, document);
                if (psiFile != null) {
                    PsiBasedStripTrailingSpacesFilter filter = this.createFilter(document);
                    filter.process(psiFile);
                    PsiBasedStripTrailingSpacesFilter psiBasedStripTrailingSpacesFilter = filter;
                    if (psiBasedStripTrailingSpacesFilter == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
                    }
                    return psiBasedStripTrailingSpacesFilter;
                }
                StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.POSTPONED;
                if (stripTrailingSpacesFilter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
                }
                return stripTrailingSpacesFilter;
            }
            StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.ALL_LINES;
            if (stripTrailingSpacesFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
            }
            return stripTrailingSpacesFilter;
        }

        @NotNull
        protected abstract PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document var1);

        protected abstract boolean isApplicableTo(@NotNull Language var1);
    }
}

