/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractRotateInteractor
extends InteractorAdapter {
    protected boolean finished;
    protected double initialRotation;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.finished = false;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        Dimension dimension = jGVTComponent.getSize();
        double d = mouseEvent.getX() - dimension.width / 2;
        double d2 = mouseEvent.getY() - dimension.height / 2;
        double d3 = -d2 / Math.sqrt(d * d + d2 * d2);
        this.initialRotation = d > 0.0 ? Math.acos(d3) : -Math.acos(d3);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        AffineTransform affineTransform = this.rotateTransform(jGVTComponent.getSize(), mouseEvent.getX(), mouseEvent.getY());
        affineTransform.concatenate(jGVTComponent.getRenderingTransform());
        jGVTComponent.setRenderingTransform(affineTransform);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        jGVTComponent.setPaintingTransform(null);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        jGVTComponent.setPaintingTransform(this.rotateTransform(jGVTComponent.getSize(), mouseEvent.getX(), mouseEvent.getY()));
    }

    protected AffineTransform rotateTransform(Dimension dimension, int n, int n2) {
        double d = n - dimension.width / 2;
        double d2 = n2 - dimension.height / 2;
        double d3 = -d2 / Math.sqrt(d * d + d2 * d2);
        double d4 = d > 0.0 ? Math.acos(d3) : -Math.acos(d3);
        return AffineTransform.getRotateInstance(d4 -= this.initialRotation, dimension.width / 2, dimension.height / 2);
    }
}

