/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddRequiredModuleFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myRequiredName;

    public AddRequiredModuleFix(PsiJavaModule module, String requiredName) {
        super(module);
        this.myRequiredName = requiredName;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("module.info.add.requires.name", this.myRequiredName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "getText"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("module.info.add.requires.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "isAvailable"));
        }
        return PsiUtil.isLanguageLevel9OrHigher(file) && startElement instanceof PsiJavaModule && startElement.getManager().isInProject(startElement) && AddRequiredModuleFix.getLBrace((PsiJavaModule)startElement) != null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "invoke"));
        }
        PsiJavaModule module = (PsiJavaModule)startElement;
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        PsiJavaModule tempModule = parserFacade.createModuleFromText("module " + module.getName() + " { requires " + this.myRequiredName + "; }");
        Iterable<PsiRequiresStatement> tempModuleRequires = tempModule.getRequires();
        PsiRequiresStatement requiresStatement = tempModuleRequires.iterator().next();
        PsiElement addingPlace = AddRequiredModuleFix.findAddingPlace(module);
        if (addingPlace != null) {
            addingPlace.getParent().addAfter(requiresStatement, addingPlace);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static PsiElement findAddingPlace(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "findAddingPlace"));
        }
        PsiElement addingPlace = ContainerUtil.iterateAndGetLastItem(module.getRequires());
        return addingPlace != null ? addingPlace : AddRequiredModuleFix.getLBrace(module);
    }

    @Nullable
    private static PsiElement getLBrace(@NotNull PsiJavaModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/AddRequiredModuleFix", "getLBrace"));
        }
        PsiJavaModuleReferenceElement nameElement = module.getNameIdentifier();
        for (PsiElement element = nameElement.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (!PsiUtil.isJavaToken(element, JavaTokenType.LBRACE)) continue;
            return element;
        }
        return null;
    }
}

