/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface ExternalAnnotatorBatchInspection
extends PairedUnfairLocalInspectionTool {
    @NotNull
    public String getShortName();

    @Override
    @NotNull
    default public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ExternalAnnotatorBatchInspection", "getInspectionForBatchShortName"));
        }
        return string;
    }

    @NotNull
    default public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/ExternalAnnotatorBatchInspection", "checkFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/ExternalAnnotatorBatchInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/ex/ExternalAnnotatorBatchInspection", "checkFile"));
        }
        String shortName = this.getShortName();
        FileViewProvider viewProvider = file.getViewProvider();
        Set<Language> relevantLanguages = viewProvider.getLanguages();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            List<ExternalAnnotator> externalAnnotators = ExternalLanguageAnnotators.allForFile(language, psiRoot);
            for (ExternalAnnotator annotator : externalAnnotators) {
                if (!shortName.equals(annotator.getPairedBatchInspectionShortName())) continue;
                ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(file, manager, false, annotator);
                if (problemDescriptorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ExternalAnnotatorBatchInspection", "checkFile"));
                }
                return problemDescriptorArray;
            }
        }
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ExternalAnnotatorBatchInspection", "checkFile"));
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }
}

