/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocReferenceInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    private static final String SHORT_NAME = "JavadocReference";

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, InspectionManager manager, boolean onTheFly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "createDescriptor"));
        }
        return manager.createProblemDescriptor(element, template, onTheFly, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    public void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, List<ProblemDescriptor> problems, InspectionManager inspectionManager, boolean onTheFly) {
        PsiDocCommentOwner commentOwner;
        PsiReference reference;
        String message;
        String tagName = tag.getName();
        PsiDocTagValue value = tag.getValueElement();
        if (value == null) {
            return;
        }
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        String string = message = info == null || !info.isInline() ? null : info.checkTagValue(value);
        if (message != null) {
            problems.add(JavaDocReferenceInspectionBase.createDescriptor(value, message, inspectionManager, onTheFly));
        }
        if ((reference = value.getReference()) == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (element != null) {
            return;
        }
        int textOffset = value.getTextOffset();
        if (textOffset == value.getTextRange().getEndOffset()) {
            return;
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return;
        }
        CharSequence paramName = value.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value.getTextRange().getEndOffset());
        String params = "<code>" + paramName + "</code>";
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (onTheFly && "param".equals(tagName) && (commentOwner = PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)commentOwner;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiDocTag[] tags = tag.getContainingComment().getTags();
            HashSet<String> unboundParams = new HashSet<String>();
            for (PsiParameter parameter : parameters) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, parameter)) continue;
                unboundParams.add(parameter.getName());
            }
            if (!unboundParams.isEmpty()) {
                fixes.add(this.createRenameReferenceQuickFix(unboundParams));
            }
        }
        fixes.add(new RemoveTagFix(tagName, paramName));
        problems.add(inspectionManager.createProblemDescriptor((PsiElement)valueElement, reference.getRangeInElement(), JavaDocReferenceInspectionBase.cannotResolveSymbolMessage(params), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly, fixes.toArray(new LocalQuickFix[fixes.size()])));
    }

    protected LocalQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return null;
    }

    private static String cannotResolveSymbolMessage(String params) {
        return InspectionsBundle.message("inspection.javadoc.problem.cannot.resolve", params);
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiJavaModule module;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkFile"));
        }
        String fileName = file.getName();
        if ("package-info.java".equals(fileName)) {
            PsiDocComment docComment = PsiTreeUtil.getChildOfType(file, PsiDocComment.class);
            return this.checkComment(docComment, file, manager, isOnTheFly);
        }
        if ("module-info.java".equals(fileName) && (module = PsiTreeUtil.getChildOfType(file, PsiJavaModule.class)) != null) {
            return this.checkComment(module.getDocComment(), file, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkMethod"));
        }
        return this.checkMember(psiMethod, manager, isOnTheFly);
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkField"));
        }
        return this.checkMember(field, manager, isOnTheFly);
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "checkClass"));
        }
        return this.checkMember(aClass, manager, isOnTheFly);
    }

    @Nullable
    private ProblemDescriptor[] checkMember(PsiDocCommentOwner docCommentOwner, InspectionManager manager, boolean isOnTheFly) {
        return this.checkComment(docCommentOwner.getDocComment(), docCommentOwner, manager, isOnTheFly);
    }

    private ProblemDescriptor[] checkComment(@Nullable PsiDocComment docComment, PsiElement context, InspectionManager manager, boolean isOnTheFly) {
        if (docComment == null) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        HashSet<PsiJavaCodeReferenceElement> references = new HashSet<PsiJavaCodeReferenceElement>();
        docComment.accept(this.getVisitor(references, context, problems, manager, isOnTheFly));
        for (PsiJavaCodeReferenceElement reference : references) {
            PsiElement referenceNameElement = reference.getReferenceNameElement();
            problems.add(manager.createProblemDescriptor(referenceNameElement != null ? referenceNameElement : reference, JavaDocReferenceInspectionBase.cannotResolveSymbolMessage("<code>" + reference.getText() + "</code>"), !isOnTheFly ? null : this.createAddQualifierFix(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        return null;
    }

    private PsiElementVisitor getVisitor(final Set<PsiJavaCodeReferenceElement> references, final PsiElement context, final List<ProblemDescriptor> problems, final InspectionManager manager, final boolean onTheFly) {
        return new JavaElementVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement(expression);
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result = reference.advancedResolve(false);
                if (result.getElement() == null && !result.isPackagePrefixPackageReference()) {
                    references.add(reference);
                }
            }

            @Override
            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocManager javadocManager = JavadocManager.SERVICE.getInstance(tag.getProject());
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspectionBase.this.visitRefInDocTag(tag, javadocManager, context, problems, manager, onTheFly);
                }
            }

            @Override
            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavadocManager javadocManager = JavadocManager.SERVICE.getInstance(tag.getProject());
                JavaDocReferenceInspectionBase.this.visitRefInDocTag(tag, javadocManager, context, problems, manager, onTheFly);
            }

            @Override
            public void visitElement(PsiElement element) {
                PsiElement[] children;
                for (PsiElement child : children = element.getChildren()) {
                    if (child instanceof PsiDocCommentOwner) continue;
                    child.accept(this);
                }
            }
        };
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.javadoc.ref.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message("group.names.javadoc.issues", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final CharSequence myParamName;

        public RemoveTagFix(String tagName, CharSequence paramName) {
            this.myTagName = tagName;
            this.myParamName = paramName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = "Remove @" + this.myTagName + " " + this.myParamName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Remove tag" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix", "getFamilyName"));
            }
            return "Remove tag";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix", "applyFix"));
            }
            PsiDocTag myTag = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiDocTag.class);
            if (myTag == null) {
                return;
            }
            myTag.delete();
        }
    }
}

