/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedStaticUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unqualified.static.usage.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (infos[0] instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("unqualified.static.usage.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unqualified.static.usage.problem.descriptor1", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unqualified.static.usage.ignore.field.option", new Object[0]), "m_ignoreStaticFieldAccesses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unqualified.static.usage.ignore.method.option", new Object[0]), "m_ignoreStaticMethodCalls");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unqualified,static.usage.only.report.static.usages.option", new Object[0]), "m_ignoreStaticAccessFromStaticContext");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedStaticCallVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos[0] instanceof PsiMethodCallExpression) {
            return new UnqualifiedStaticAccessFix(false);
        }
        return new UnqualifiedStaticAccessFix(true);
    }

    private class UnqualifiedStaticCallVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedStaticCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticCallVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (!this.isUnqualifiedStaticAccess(methodExpression)) {
                return;
            }
            this.registerError((PsiElement)methodExpression, expression);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticCallVisitor", "visitReferenceExpression"));
            }
            super.visitReferenceExpression(expression);
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("final") && PsiUtil.isOnAssignmentLeftHand(expression)) {
                return;
            }
            if (!this.isUnqualifiedStaticAccess(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean isUnqualifiedStaticAccess(PsiReferenceExpression expression) {
            PsiMember member;
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext && (member = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class)) != null && member.hasModifierProperty("static")) {
                return false;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (qualifierExpression != null) {
                return false;
            }
            JavaResolveResult resolveResult = expression.advancedResolve(false);
            PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
            if (currentFileResolveScope instanceof PsiImportStaticStatement) {
                return false;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiField) && !(element instanceof PsiMethod)) {
                return false;
            }
            PsiMember member2 = (PsiMember)element;
            if (member2 instanceof PsiEnumConstant && expression.getParent() instanceof PsiSwitchLabelStatement) {
                return false;
            }
            return member2.hasModifierProperty("static");
        }
    }

    private static class UnqualifiedStaticAccessFix
    extends InspectionGadgetsFix {
        private final boolean m_fixField;

        UnqualifiedStaticAccessFix(boolean fixField) {
            this.m_fixField = fixField;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.m_fixField) {
                String string = InspectionGadgetsBundle.message("unqualified.static.usage.qualify.field.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticAccessFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("unqualified.static.usage.qualify.method.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticAccessFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Qualify static access" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticAccessFix", "getFamilyName"));
            }
            return "Qualify static access";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression expression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiMember member = (PsiMember)expression.resolve();
            assert (member != null);
            PsiClass containingClass = member.getContainingClass();
            assert (containingClass != null);
            String className = containingClass.getName();
            String text2 = expression.getText();
            PsiReplacementUtil.replaceExpression(expression, className + '.' + text2);
        }
    }
}

