/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiPrimitiveType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final DfaFactMap myFactMap;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        if (dfaVar == null) {
            DfaVariableState.$$$reportNull$$$0(0);
        }
        this(dfaVar.getInherentFacts());
    }

    public boolean isSuperStateOf(DfaVariableState that) {
        return this.myFactMap.isSuperStateOf(that.myFactMap);
    }

    DfaVariableState(@NotNull DfaFactMap factMap) {
        if (factMap == null) {
            DfaVariableState.$$$reportNull$$$0(1);
        }
        this.myFactMap = factMap;
        this.myHash = this.myFactMap.hashCode();
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(2);
        }
        if (dfaType.getDfaType().getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        TypeConstraint typeConstraint = this.getTypeConstraint();
        TypeConstraint newTypeConstraint = typeConstraint.withInstanceofValue(dfaType);
        if (newTypeConstraint == null) {
            return null;
        }
        DfaVariableState result = dfaType.isNullable() ? this.withFact(DfaFactType.CAN_BE_NULL, true) : this;
        return result.withFact(DfaFactType.TYPE_CONSTRAINT, newTypeConstraint);
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaTypeValue dfaType) {
        TypeConstraint typeConstraint;
        TypeConstraint newTypeConstraint;
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(3);
        }
        return (newTypeConstraint = (typeConstraint = this.getTypeConstraint()).withNotInstanceofValue(dfaType)) == null ? null : this.withFact(DfaFactType.TYPE_CONSTRAINT, newTypeConstraint);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type) {
        if (type == null) {
            DfaVariableState.$$$reportNull$$$0(4);
        }
        DfaVariableState dfaVariableState = this.withFact(DfaFactType.TYPE_CONSTRAINT, this.getTypeConstraint().withoutType(type));
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(5);
        }
        return dfaVariableState;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && Objects.equals(this.myFactMap, aState.myFactMap);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull DfaFactMap factMap) {
        if (factMap == null) {
            DfaVariableState.$$$reportNull$$$0(6);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(factMap);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(7);
        }
        return dfaVariableState;
    }

    public String toString() {
        return "State: " + this.myFactMap;
    }

    @NotNull
    Nullness getNullability() {
        Nullness nullness = NullnessUtil.fromBoolean(this.myFactMap.get(DfaFactType.CAN_BE_NULL));
        if (nullness == null) {
            DfaVariableState.$$$reportNull$$$0(8);
        }
        return nullness;
    }

    public boolean isNotNull() {
        return this.getNullability() == Nullness.NOT_NULL;
    }

    @NotNull
    DfaVariableState withNotNull() {
        DfaVariableState dfaVariableState = this.getNullability() == Nullness.NOT_NULL ? this : this.withoutFact(DfaFactType.CAN_BE_NULL);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(9);
        }
        return dfaVariableState;
    }

    @NotNull
    <T> DfaVariableState withFact(DfaFactType<T> type, T value) {
        DfaFactMap factMap = this.myFactMap.with(type, value);
        DfaVariableState dfaVariableState = this.myFactMap.equals(factMap) ? this : this.createCopy(factMap);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(10);
        }
        return dfaVariableState;
    }

    <T> DfaVariableState withoutFact(DfaFactType<T> type) {
        return this.withFact(type, null);
    }

    @Nullable
    <T> DfaVariableState intersectFact(DfaFactType<T> type, T value) {
        DfaFactMap factMap = this.myFactMap.intersect(type, value);
        return factMap == null ? null : (this.myFactMap.equals(factMap) ? this : this.createCopy(factMap));
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value) {
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(11);
        }
        return dfaVariableState;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    @NotNull
    public TypeConstraint getTypeConstraint() {
        TypeConstraint fact = this.getFact(DfaFactType.TYPE_CONSTRAINT);
        TypeConstraint typeConstraint = fact == null ? TypeConstraint.EMPTY : fact;
        if (typeConstraint == null) {
            DfaVariableState.$$$reportNull$$$0(12);
        }
        return typeConstraint;
    }

    @Nullable
    public <T> T getFact(@NotNull DfaFactType<T> factType) {
        if (factType == null) {
            DfaVariableState.$$$reportNull$$$0(13);
        }
        return this.myFactMap.get(factType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaVariableState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaVariableState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withNotNull";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withFact";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceofValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNotInstanceofValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withoutType";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

