/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ThrowsRuntimeExceptionInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throws.runtime.exception.display.name", new Object[0]);
        if (string == null) {
            ThrowsRuntimeExceptionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("throws.runtime.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            ThrowsRuntimeExceptionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowsRuntimeExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThrowsRuntimeExceptionVisitor
    extends BaseInspectionVisitor {
        private ThrowsRuntimeExceptionVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiJavaCodeReferenceElement[] referenceElements;
            super.visitMethod(method);
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = throwsList.getReferenceElements()) {
                PsiClass aClass;
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass) || !InheritanceUtil.isInheritor(aClass = (PsiClass)target, "java.lang.RuntimeException")) continue;
                String className = aClass.getName();
                this.registerError((PsiElement)referenceElement, className, referenceElement);
            }
        }
    }
}

