/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorKey
implements Comparable<ColorKey> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.colors.ColorKey");
    private static final Color NULL_COLOR = ColorUtil.marker("NULL_COLOR");
    private static final Map<String, ColorKey> ourRegistry = ConcurrentFactoryMap.createMap(ColorKey::new);
    private final String myExternalName;
    private Color myDefaultColor;
    private ColorKey myFallbackColorKey;

    private ColorKey(@NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(0);
        }
        this.myDefaultColor = NULL_COLOR;
        this.myExternalName = externalName;
    }

    @NotNull
    public static ColorKey find(@NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(1);
        }
        ColorKey colorKey = ourRegistry.get(externalName);
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(2);
        }
        return colorKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        String string = this.myExternalName;
        if (string == null) {
            ColorKey.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull ColorKey key) {
        if (key == null) {
            ColorKey.$$$reportNull$$$0(4);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public Color getDefaultColor() {
        if (this.myDefaultColor == NULL_COLOR) {
            this.myDefaultColor = null;
        }
        return this.myDefaultColor;
    }

    @Nullable
    public ColorKey getFallbackColorKey() {
        return this.myFallbackColorKey;
    }

    public void setFallbackColorKey(@Nullable ColorKey fallbackColorKey) {
        JBIterable<ColorKey> it;
        this.myFallbackColorKey = fallbackColorKey;
        if (fallbackColorKey != null && (it = JBIterable.generate(fallbackColorKey, o -> o == this ? null : o.myFallbackColorKey)).find(o -> o == this) == this) {
            String cycle = StringUtil.join(it.map(ColorKey::getExternalName), "->");
            LOG.error("Cycle detected: " + cycle);
        }
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(5);
        }
        ColorKey colorKey = ColorKey.find(externalName);
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(6);
        }
        return colorKey;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName, @Nullable ColorKey fallbackColorKey) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(7);
        }
        ColorKey key = ColorKey.createColorKey(externalName);
        key.setFallbackColorKey(fallbackColorKey);
        ColorKey colorKey = key;
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(8);
        }
        return colorKey;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName, @Nullable Color defaultColor) {
        ColorKey key;
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(9);
        }
        if ((key = ColorKey.createColorKey(externalName)).getDefaultColor() == null) {
            key.myDefaultColor = defaultColor;
        }
        ColorKey colorKey = key;
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(10);
        }
        return colorKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/ColorKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/ColorKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createColorKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

