/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent(baseClass, aClass) || aClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass, boolean includeSelf, @NotNull Processor<PsiClass> superProcessor) {
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass, superProcessor, (Set<PsiClass>)new THashSet());
    }

    private static boolean processSupers(@NotNull PsiClass aClass, @NotNull Processor<PsiClass> superProcessor, @NotNull Set<PsiClass> visited) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(1);
        }
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(2);
        }
        if (visited == null) {
            InheritanceUtil.$$$reportNull$$$0(3);
        }
        if (!visited.add(aClass)) {
            return true;
        }
        for (PsiClass intf : aClass.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited)) continue;
            return false;
        }
        PsiClass superClass = aClass.getSuperClass();
        return superClass == null || superProcessor.process(superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiType type, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(4);
        }
        if (type instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type).resolve(), baseClassName);
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                if (!InheritanceUtil.isInheritor(conjunct, baseClassName)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, @NotNull String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(5);
        }
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, @NotNull String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(@NotNull PsiClass aClass, @NotNull Set<PsiClass> results, boolean includeNonProject) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(7);
        }
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(8);
        }
        InheritanceUtil.getSuperClassesOfList(aClass.getSuperTypes(), results, includeNonProject, (Set<PsiClass>)new THashSet(), aClass.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(9);
        }
        LinkedHashSet<PsiClass> result = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass, result, true);
        return result;
    }

    private static void getSuperClassesOfList(@NotNull PsiClassType[] types, @NotNull Set<PsiClass> results, boolean includeNonProject, @NotNull Set<PsiClass> visited, @NotNull PsiManager manager) {
        if (types == null) {
            InheritanceUtil.$$$reportNull$$$0(10);
        }
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(11);
        }
        if (visited == null) {
            InheritanceUtil.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            InheritanceUtil.$$$reportNull$$$0(13);
        }
        for (PsiClassType type : types) {
            PsiClass resolved = type.resolve();
            if (resolved == null || !visited.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited, manager);
        }
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass, PsiElement scope, boolean isSuperClassAccepted, boolean isTypeParamsAccepted) {
        return InheritanceUtil.hasEnclosingInstanceInScope(aClass, scope, psiClass -> isSuperClassAccepted, isTypeParamsAccepted);
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass, PsiElement scope, Condition<PsiClass> isSuperClassAccepted, boolean isTypeParamsAccepted) {
        PsiElement place;
        PsiManager manager = aClass.getManager();
        for (place = scope; place != null && place != aClass && !(place instanceof PsiFile); place = place.getParent()) {
            PsiModifierList modifierList;
            if (place instanceof PsiClass) {
                if (isSuperClassAccepted.value((PsiClass)place) ? InheritanceUtil.isInheritorOrSelf((PsiClass)place, aClass, true) : manager.areElementsEquivalent(place, aClass)) {
                    return true;
                }
                if (isTypeParamsAccepted && place instanceof PsiTypeParameter) {
                    return true;
                }
            }
            if (!(place instanceof PsiModifierListOwner) || (modifierList = ((PsiModifierListOwner)place).getModifierList()) == null || !modifierList.hasModifierProperty("static")) continue;
            return false;
        }
        return place == aClass;
    }

    public static boolean processSuperTypes(@NotNull PsiType type, boolean includeSelf, @NotNull Processor<PsiType> processor) {
        if (type == null) {
            InheritanceUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            InheritanceUtil.$$$reportNull$$$0(15);
        }
        if (includeSelf && !processor.process(type)) {
            return false;
        }
        return InheritanceUtil.processSuperTypes(type, processor, new HashSet<PsiType>());
    }

    private static boolean processSuperTypes(PsiType type, Processor<PsiType> processor, Set<PsiType> visited) {
        if (!visited.add(type)) {
            return true;
        }
        for (PsiType superType : type.getSuperTypes()) {
            if (!processor.process(superType)) {
                return false;
            }
            InheritanceUtil.processSuperTypes(superType, processor, visited);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superProcessor";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/InheritanceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processSupers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClasses";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClassesOfList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

