/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ContractInference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter");
    public static final int MAX_CONTRACT_COUNT = 10;

    @NotNull
    public static List<StandardMethodContract> inferContracts(@NotNull PsiMethodImpl method) {
        if (method == null) {
            ContractInference.$$$reportNull$$$0(0);
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            List<StandardMethodContract> list = Collections.emptyList();
            if (list == null) {
                ContractInference.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue(method, () -> {
            List<Object> preContracts;
            MethodData data;
            List result;
            if (method == null) {
                ContractInference.$$$reportNull$$$0(14);
            }
            if ((result = RecursionManager.doPreventingRecursion(method, true, () -> ContractInference.lambda$null$0(method, data, preContracts = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? Collections.emptyList() : data.getContracts()))) == null) {
                result = Collections.emptyList();
            }
            return CachedValueProvider.Result.create(result, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        if (list == null) {
            ContractInference.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<StandardMethodContract> postProcessContracts(@NotNull PsiMethodImpl method, MethodData data, List<PreContract> rawContracts) {
        List<StandardMethodContract> compatible;
        List<StandardMethodContract> contracts2;
        if (method == null) {
            ContractInference.$$$reportNull$$$0(3);
        }
        if ((contracts2 = ContainerUtil.concat(rawContracts, c -> {
            if (method == null) {
                ContractInference.$$$reportNull$$$0(13);
            }
            return c.toContracts(method, data.methodBody(method));
        })).isEmpty()) {
            List<StandardMethodContract> list = Collections.emptyList();
            if (list == null) {
                ContractInference.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = ContractInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter(contracts2, contract -> {
            if (method == null) {
                ContractInference.$$$reportNull$$$0(12);
            }
            return ContractInference.isContractCompatibleWithMethod(method, returnType, contract);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName(method) + ", shrinking the list");
            List<StandardMethodContract> list = compatible.subList(0, 10);
            if (list == null) {
                ContractInference.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<StandardMethodContract> list = compatible;
        if (list == null) {
            ContractInference.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isContractCompatibleWithMethod(@NotNull PsiMethod method, PsiType returnType, StandardMethodContract contract) {
        if (method == null) {
            ContractInference.$$$reportNull$$$0(7);
        }
        if (ContractInference.hasContradictoryExplicitParameterNullity(method, contract)) {
            return false;
        }
        if (ContractInference.isReturnNullitySpecifiedExplicitly(method, contract)) {
            return false;
        }
        if (ContractInference.isContradictingExplicitNullableReturn(method, contract)) {
            return false;
        }
        return InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue);
    }

    private static boolean hasContradictoryExplicitParameterNullity(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            ContractInference.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < contract.arguments.length; ++i) {
            if (contract.arguments[i] != MethodContract.ValueConstraint.NULL_VALUE || !NullableNotNullManager.isNotNull(method.getParameterList().getParameters()[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isContradictingExplicitNullableReturn(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            ContractInference.$$$reportNull$$$0(9);
        }
        return contract.returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE && Arrays.stream(contract.arguments).allMatch(c -> c == MethodContract.ValueConstraint.ANY_VALUE) && NullableNotNullManager.getInstance(method.getProject()).isNullable(method, false);
    }

    private static boolean isReturnNullitySpecifiedExplicitly(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            ContractInference.$$$reportNull$$$0(10);
        }
        if (contract.returnValue != MethodContract.ValueConstraint.NOT_NULL_VALUE && contract.returnValue != MethodContract.ValueConstraint.NULL_VALUE) {
            return false;
        }
        return NullableNotNullManager.getInstance(method.getProject()).isNotNull(method, false);
    }

    @NotNull
    private static List<StandardMethodContract> boxReturnValues(List<StandardMethodContract> contracts2) {
        List<StandardMethodContract> list = ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.returnValue == MethodContract.ValueConstraint.FALSE_VALUE || contract.returnValue == MethodContract.ValueConstraint.TRUE_VALUE) {
                return new StandardMethodContract(contract.arguments, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            }
            return contract;
        });
        if (list == null) {
            ContractInference.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ List lambda$null$0(@NotNull PsiMethodImpl method, MethodData data, List preContracts) {
        if (method == null) {
            ContractInference.$$$reportNull$$$0(15);
        }
        return ContractInference.postProcessContracts(method, data, preContracts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractInference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractInference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "inferContracts";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessContracts";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "boxReturnValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferContracts";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "postProcessContracts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isContractCompatibleWithMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasContradictoryExplicitParameterNullity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isContradictingExplicitNullableReturn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReturnNullitySpecifiedExplicitly";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postProcessContracts$3";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postProcessContracts$2";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferContracts$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

