/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffString
extends CharArrayCharSequence {
    @NotNull
    public static final DiffString EMPTY = new DiffString(new char[0], 0, 0);

    @Nullable
    public static DiffString createNullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return DiffString.create(string);
    }

    @NotNull
    public static DiffString create(@NotNull String string) {
        if (string == null) {
            DiffString.$$$reportNull$$$0(0);
        }
        if (string.isEmpty()) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(1);
            }
            return diffString;
        }
        DiffString diffString = DiffString.create(string.toCharArray());
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(2);
        }
        return diffString;
    }

    @NotNull
    static DiffString create(@NotNull char[] data) {
        if (data == null) {
            DiffString.$$$reportNull$$$0(3);
        }
        DiffString diffString = DiffString.create(data, 0, data.length);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(4);
        }
        return diffString;
    }

    @NotNull
    static DiffString create(@NotNull char[] data, int start, int length) {
        if (data == null) {
            DiffString.$$$reportNull$$$0(5);
        }
        if (length == 0) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(6);
            }
            return diffString;
        }
        DiffString.checkBounds(start, length, data.length);
        DiffString diffString = new DiffString(data, start, length);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(7);
        }
        return diffString;
    }

    private DiffString(@NotNull char[] data, int start, int length) {
        if (data == null) {
            DiffString.$$$reportNull$$$0(8);
        }
        super(data, start, start + length);
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    private char data(int index) {
        return this.charAt(index);
    }

    @NotNull
    public DiffString substring(int start) {
        DiffString diffString = this.substring(start, this.length());
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(9);
        }
        return diffString;
    }

    @NotNull
    public DiffString substring(int start, int end) {
        if (start == 0 && end == this.length()) {
            DiffString diffString = this;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(10);
            }
            return diffString;
        }
        DiffString.checkBounds(start, end - start, this.length());
        DiffString diffString = DiffString.create(this.myChars, this.myStart + start, end - start);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(11);
        }
        return diffString;
    }

    @Override
    @NotNull
    public DiffString subSequence(int start, int end) {
        DiffString diffString = this.substring(start, end);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(12);
        }
        return diffString;
    }

    @NotNull
    public DiffString copy() {
        DiffString diffString = DiffString.create(Arrays.copyOfRange(this.myChars, this.myStart, this.myStart + this.length()));
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(13);
        }
        return diffString;
    }

    public void copyData(@NotNull char[] dst, int start) {
        if (dst == null) {
            DiffString.$$$reportNull$$$0(14);
        }
        DiffString.checkBounds(start, this.length(), dst.length);
        System.arraycopy(this.myChars, this.myStart, dst, start, this.length());
    }

    @Nullable
    public static DiffString concatenateNullable(@Nullable DiffString s1, @Nullable DiffString s2) {
        if (s1 == null || s2 == null) {
            if (s1 != null) {
                return s1;
            }
            if (s2 != null) {
                return s2;
            }
            return null;
        }
        return DiffString.concatenate(s1, s2);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1 == null) {
            DiffString.$$$reportNull$$$0(15);
        }
        if (s2 == null) {
            DiffString.$$$reportNull$$$0(16);
        }
        if (s1.isEmpty()) {
            DiffString diffString = s2;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(17);
            }
            return diffString;
        }
        if (s2.isEmpty()) {
            DiffString diffString = s1;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(18);
            }
            return diffString;
        }
        if (s1.myChars == s2.myChars && s1.myStart + s1.length() == s2.myStart) {
            DiffString diffString = DiffString.create(s1.myChars, s1.myStart, s1.length() + s2.length());
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(19);
            }
            return diffString;
        }
        char[] data = new char[s1.length() + s2.length()];
        System.arraycopy(s1.myChars, s1.myStart, data, 0, s1.length());
        System.arraycopy(s2.myChars, s2.myStart, data, s1.length(), s2.length());
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(20);
        }
        return diffString;
    }

    public static boolean canInplaceConcatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1 == null) {
            DiffString.$$$reportNull$$$0(21);
        }
        if (s2 == null) {
            DiffString.$$$reportNull$$$0(22);
        }
        if (s1.isEmpty()) {
            return true;
        }
        if (s2.isEmpty()) {
            return true;
        }
        return s1.myChars == s2.myChars && s1.myStart + s1.length() == s2.myStart;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings) {
        if (strings == null) {
            DiffString.$$$reportNull$$$0(23);
        }
        DiffString diffString = DiffString.concatenateCopying(strings, 0, strings.length);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(24);
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings, int start, int length) {
        if (strings == null) {
            DiffString.$$$reportNull$$$0(25);
        }
        DiffString.checkBounds(start, length, strings.length);
        int len = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            len += string == null ? 0 : string.length();
        }
        if (len == 0) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(26);
            }
            return diffString;
        }
        char[] data = new char[len];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            System.arraycopy(string.myChars, string.myStart, data, index, string.length());
            index += string.length();
        }
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(27);
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s, char c) {
        if (s == null) {
            DiffString.$$$reportNull$$$0(28);
        }
        if (s.myStart + s.length() < s.myChars.length && s.data(s.length()) == c) {
            DiffString diffString = DiffString.create(s.myChars, s.myStart, s.length() + 1);
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(29);
            }
            return diffString;
        }
        char[] data = new char[s.length() + 1];
        System.arraycopy(s.myChars, s.myStart, data, 0, s.length());
        data[s.length()] = c;
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(30);
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(char c, @NotNull DiffString s) {
        if (s == null) {
            DiffString.$$$reportNull$$$0(31);
        }
        if (s.myStart > 0 && s.data(-1) == c) {
            DiffString diffString = DiffString.create(s.myChars, s.myStart - 1, s.length() + 1);
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(32);
            }
            return diffString;
        }
        char[] data = new char[s.length() + 1];
        System.arraycopy(s.myChars, s.myStart, data, 1, s.length());
        data[0] = c;
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(33);
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings) {
        if (strings == null) {
            DiffString.$$$reportNull$$$0(34);
        }
        DiffString diffString = DiffString.concatenate(strings, 0, strings.length);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(35);
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings, int start, int length) {
        if (strings == null) {
            DiffString.$$$reportNull$$$0(36);
        }
        DiffString.checkBounds(start, length, strings.length);
        char[] data = null;
        int startIndex = 0;
        int endIndex = 0;
        boolean linearized = true;
        for (int i = 0; i < length; ++i) {
            DiffString string = strings[start + i];
            if (string == null || string.isEmpty()) continue;
            if (data == null) {
                data = string.myChars;
                startIndex = string.myStart;
                endIndex = string.myStart + string.length();
                continue;
            }
            if (data != string.myChars || string.myStart != endIndex) {
                linearized = false;
                break;
            }
            endIndex += string.length();
        }
        if (linearized) {
            if (data == null) {
                DiffString diffString = EMPTY;
                if (diffString == null) {
                    DiffString.$$$reportNull$$$0(37);
                }
                return diffString;
            }
            DiffString diffString = DiffString.create(data, startIndex, endIndex - startIndex);
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(38);
            }
            return diffString;
        }
        DiffString diffString = DiffString.concatenateCopying(strings, start, length);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(39);
        }
        return diffString;
    }

    @NotNull
    public DiffString append(char c) {
        DiffString diffString = DiffString.concatenate(this, c);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(40);
        }
        return diffString;
    }

    @NotNull
    public DiffString preappend(char c) {
        DiffString diffString = DiffString.concatenate(c, this);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(41);
        }
        return diffString;
    }

    public static boolean isWhiteSpace(char c) {
        return StringUtil.isWhiteSpace(c);
    }

    public boolean isEmptyOrSpaces() {
        if (this.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (DiffString.isWhiteSpace(this.data(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public DiffString trim() {
        int start;
        int end = this.length();
        for (start = 0; start < end && DiffString.isWhiteSpace(this.data(start)); ++start) {
        }
        while (end > start && DiffString.isWhiteSpace(this.data(end - 1))) {
            --end;
        }
        DiffString diffString = this.substring(start, end);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(42);
        }
        return diffString;
    }

    @NotNull
    public DiffString trimLeading() {
        int i;
        for (i = 0; i < this.length() && DiffString.isWhiteSpace(this.data(i)); ++i) {
        }
        DiffString diffString = this.substring(i, this.length());
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(43);
        }
        return diffString;
    }

    @NotNull
    public DiffString trimTrailing() {
        int end;
        for (end = this.length(); end > 0 && DiffString.isWhiteSpace(this.data(end - 1)); --end) {
        }
        DiffString diffString = this.substring(0, end);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(44);
        }
        return diffString;
    }

    @NotNull
    public DiffString getLeadingSpaces() {
        int i;
        for (i = 0; i < this.length() && this.data(i) == ' '; ++i) {
        }
        DiffString diffString = this.substring(0, i);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(45);
        }
        return diffString;
    }

    @NotNull
    public DiffString skipSpaces() {
        DiffString s = this.trim();
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!DiffString.isWhiteSpace(s.data(i))) continue;
            ++count;
        }
        if (count == 0) {
            DiffString diffString = s;
            if (diffString == null) {
                DiffString.$$$reportNull$$$0(46);
            }
            return diffString;
        }
        char[] data = new char[s.length() - count];
        int index = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (DiffString.isWhiteSpace(s.data(i))) continue;
            data[index] = s.data(i);
            ++index;
        }
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            DiffString.$$$reportNull$$$0(47);
        }
        return diffString;
    }

    public int indexOf(char c) {
        return StringUtil.indexOf((CharSequence)this, c);
    }

    public boolean endsWith(char c) {
        if (this.isEmpty()) {
            return false;
        }
        return this.data(this.length() - 1) == c;
    }

    public static void checkBounds(int start, int length, int maxLength) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (start + length > maxLength) {
            throw new StringIndexOutOfBoundsException(start + length);
        }
    }

    @NotNull
    public DiffString[] tokenize() {
        DiffString[] diffStringArray = new LineTokenizer(this).execute();
        if (diffStringArray == null) {
            DiffString.$$$reportNull$$$0(48);
        }
        return diffStringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/string/DiffString";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 23: 
            case 25: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/string/DiffString";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenate";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenateCopying";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "preappend";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadingSpaces";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "skipSpaces";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyData";
                break;
            }
            case 15: 
            case 16: 
            case 28: 
            case 31: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "concatenate";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canInplaceConcatenate";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "concatenateCopying";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineTokenizer
    extends LineTokenizerBase<DiffString> {
        @NotNull
        private final DiffString myText;

        public LineTokenizer(@NotNull DiffString text2) {
            if (text2 == null) {
                LineTokenizer.$$$reportNull$$$0(0);
            }
            this.myText = text2;
        }

        @NotNull
        public DiffString[] execute() {
            ArrayList lines = new ArrayList();
            this.doExecute(lines);
            DiffString[] diffStringArray = ContainerUtil.toArray(lines, new DiffString[lines.size()]);
            if (diffStringArray == null) {
                LineTokenizer.$$$reportNull$$$0(1);
            }
            return diffStringArray;
        }

        @Override
        protected void addLine(List<DiffString> lines, int start, int end, boolean appendNewLine) {
            if (appendNewLine) {
                lines.add(this.myText.substring(start, end).append('\n'));
            } else {
                lines.add(this.myText.substring(start, end));
            }
        }

        @Override
        protected char charAt(int index) {
            return this.myText.data(index);
        }

        @Override
        protected int length() {
            return this.myText.length();
        }

        @Override
        @NotNull
        protected String substring(int start, int end) {
            String string = this.myText.substring(start, end).toString();
            if (string == null) {
                LineTokenizer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substring";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

