/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class CastConflictsWithInstanceofInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.display.name", new Object[0]);
        if (string == null) {
            CastConflictsWithInstanceofInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.problem.descriptor", referenceExpression.getText());
        if (string == null) {
            CastConflictsWithInstanceofInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String castExpressionType = ((PsiTypeElement)infos[1]).getText();
        String instanceofType = ((PsiTypeElement)infos[2]).getText();
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ReplaceCastFix(instanceofType, castExpressionType), new ReplaceInstanceofFix(instanceofType, castExpressionType)};
        if (inspectionGadgetsFixArray == null) {
            CastConflictsWithInstanceofInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastConflictsWithInstanceofVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceInstanceofFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        public ReplaceInstanceofFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace instanceOf type" == null) {
                ReplaceInstanceofFix.$$$reportNull$$$0(0);
            }
            return "Replace instanceOf type";
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix2", this.myInstanceofType, this.myCastType);
            if (string == null) {
                ReplaceInstanceofFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return instanceofTypeElement.replace(castTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceInstanceofFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ReplaceCastFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        public ReplaceCastFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix1", this.myCastType, this.myInstanceofType);
            if (string == null) {
                ReplaceCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace cast type" == null) {
                ReplaceCastFix.$$$reportNull$$$0(1);
            }
            return "Replace cast type";
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return castTypeElement.replace(instanceofTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceCastFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static abstract class ReplaceFix
    extends InspectionGadgetsFix {
        protected ReplaceFix() {
        }

        @Override
        protected final void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression reference;
            PsiTypeElement castTypeElement;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
                castTypeElement = typeCastExpression.getCastType();
                PsiExpression operand = typeCastExpression.getOperand();
                if (!(operand instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)operand;
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
                castTypeElement = classObjectAccessExpression.getOperand();
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression argument = arguments[0];
                if (!(argument instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)argument;
            } else {
                return;
            }
            if (castTypeElement == null) {
                return;
            }
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castTypeElement.getType(), reference, element);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            PsiElement newElement = this.replace(castTypeElement, instanceofTypeElement);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            codeStyleManager.shortenClassReferences(newElement);
        }

        protected abstract PsiElement replace(PsiTypeElement var1, PsiTypeElement var2);
    }

    private static class CastConflictsWithInstanceofVisitor
    extends BaseInspectionVisitor {
        private CastConflictsWithInstanceofVisitor() {
        }

        @Override
        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                CastConflictsWithInstanceofVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiTypeElement castType = expression.getCastType();
            if (castType == null) {
                return;
            }
            PsiType type = castType.getType();
            PsiExpression operand = ParenthesesUtils.stripParentheses(expression.getOperand());
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(type, referenceExpression, expression);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression, castType, instanceofTypeElement);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"cast".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Class".equals(qualifiedName)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiType castType = operand.getType();
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[0]);
            if (!(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castType, referenceExpression, expression);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            this.registerError((PsiElement)expression, referenceExpression, operand, instanceofTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$CastConflictsWithInstanceofVisitor", "visitTypeCastExpression"));
        }
    }
}

