/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageLevelProjectExtension {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.LanguageLevelProjectExtension");
    private Boolean myDefault;

    public static LanguageLevelProjectExtension getInstance(Project project) {
        return ServiceManager.getService(project, LanguageLevelProjectExtension.class);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    public abstract void setLanguageLevel(@NotNull LanguageLevel var1);

    @Nullable
    public Boolean getDefault() {
        return this.myDefault;
    }

    public void setDefault(@Nullable Boolean value) {
        this.myDefault = value;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.debug("Set " + value + "\n" + ExceptionUtil.currentStackTrace());
        }
    }

    public boolean isDefault() {
        return this.myDefault != null && this.myDefault != false;
    }

    public void languageLevelsChanged() {
    }
}

