/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMacrosCollector
extends PathMacroMap {
    public static final ExtensionPointName<PathMacroFilter> MACRO_FILTER_EXTENSION_POINT_NAME = ExtensionPointName.create("com.intellij.pathMacroFilter");
    public static final Pattern MACRO_PATTERN = Pattern.compile("\\$([\\w\\-\\.]+?)\\$");
    private final Matcher myMatcher;
    private final Map<String, String> myMacroMap = ContainerUtilRt.newLinkedHashMap();

    private PathMacrosCollector() {
        this.myMatcher = MACRO_PATTERN.matcher("");
    }

    @NotNull
    public static Set<String> getMacroNames(@NotNull Element e) {
        if (e == null) {
            PathMacrosCollector.$$$reportNull$$$0(0);
        }
        Set<String> set = PathMacrosCollector.getMacroNames(e, new CompositePathMacroFilter(Extensions.getExtensions(MACRO_FILTER_EXTENSION_POINT_NAME)), PathMacrosImpl.getInstanceEx());
        if (set == null) {
            PathMacrosCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Set<String> getMacroNames(Element root, @Nullable PathMacroFilter filter, @NotNull PathMacrosImpl pathMacros) {
        if (pathMacros == null) {
            PathMacrosCollector.$$$reportNull$$$0(2);
        }
        PathMacrosCollector collector = new PathMacrosCollector();
        collector.substitute(root, true, false, filter);
        Set<String> preResult = collector.myMacroMap.keySet();
        if (preResult.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PathMacrosCollector.$$$reportNull$$$0(3);
            }
            return set;
        }
        SmartHashSet<String> result = new SmartHashSet<String>(preResult);
        result.removeAll(pathMacros.getSystemMacroNames());
        result.removeAll(pathMacros.getLegacyMacroNames());
        result.removeAll(pathMacros.getToolMacroNames());
        result.removeAll(pathMacros.getIgnoredMacroNames());
        SmartHashSet<String> smartHashSet = result;
        if (smartHashSet == null) {
            PathMacrosCollector.$$$reportNull$$$0(4);
        }
        return smartHashSet;
    }

    @Override
    @NotNull
    public String substituteRecursively(@NotNull String text2, boolean caseSensitive) {
        if (text2 == null) {
            PathMacrosCollector.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty(text2)) {
            String string = text2;
            if (string == null) {
                PathMacrosCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        this.myMatcher.reset(text2);
        while (this.myMatcher.find()) {
            this.myMacroMap.put(this.myMatcher.group(1), null);
        }
        String string = text2;
        if (string == null) {
            PathMacrosCollector.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public String substitute(String text2, boolean caseSensitive) {
        if (StringUtil.isEmpty(text2)) {
            return text2;
        }
        int startPos = -1;
        if (text2.charAt(0) == '$') {
            startPos = 0;
        } else {
            for (String protocol : ReplacePathToMacroMap.PROTOCOLS) {
                if (text2.length() <= protocol.length() + 4 || !text2.startsWith(protocol) || text2.charAt(protocol.length()) != ':') continue;
                startPos = protocol.length() + 1;
                if (text2.charAt(startPos) == '/') {
                    ++startPos;
                }
                if (text2.charAt(startPos) != '/') continue;
                ++startPos;
            }
        }
        if (startPos < 0) {
            return text2;
        }
        this.myMatcher.reset(text2).region(startPos, text2.length());
        if (this.myMatcher.lookingAt()) {
            this.myMacroMap.put(this.myMatcher.group(1), null);
        }
        return text2;
    }

    @Override
    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/PathMacrosCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMacros";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/PathMacrosCollector";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMacroNames";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

