/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddHtmlTagOrAttributeToCustomsIntention;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RequiredAttributesInspectionBase
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    @NonNls
    public static final Key<InspectionProfileEntry> SHORT_NAME_KEY = Key.create("RequiredAttributes");
    protected static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.htmlInspections.RequiredAttributesInspection");
    public String myAdditionalRequiredHtmlAttributes = "";

    private static String appendName(String toAppend, String text2) {
        toAppend = !toAppend.isEmpty() ? toAppend + "," + text2 : text2;
        return toAppend;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.required.attributes.display.name", new Object[0]);
        if (string == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("RequiredAttributes" == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(2);
        }
        return "RequiredAttributes";
    }

    @Override
    public String getAdditionalEntries() {
        return this.myAdditionalRequiredHtmlAttributes;
    }

    @Override
    public void addEntry(String text2) {
        this.myAdditionalRequiredHtmlAttributes = RequiredAttributesInspectionBase.appendName(this.getAdditionalEntries(), text2);
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    public static LocalQuickFix getIntentionAction(String name) {
        return new AddHtmlTagOrAttributeToCustomsIntention(SHORT_NAME_KEY, name, XmlBundle.message("add.optional.html.attribute", name));
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(4);
        }
        String name = tag.getName();
        XmlElementDescriptor elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
        if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
            elementDescriptor = tag.getDescriptor();
        }
        if (elementDescriptor == null) {
            return;
        }
        if (elementDescriptor instanceof XmlHighlightingAwareElementDescriptor && !((XmlHighlightingAwareElementDescriptor)((Object)elementDescriptor)).shouldCheckRequiredAttributes()) {
            return;
        }
        XmlAttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashSet<String> requiredAttributes = null;
        for (XmlAttributeDescriptor attribute : attributeDescriptors) {
            if (attribute == null || !attribute.isRequired()) continue;
            if (requiredAttributes == null) {
                requiredAttributes = new HashSet<String>();
            }
            requiredAttributes.add(attribute.getName(tag));
        }
        if (requiredAttributes != null) {
            for (String attrName : requiredAttributes) {
                if (RequiredAttributesInspectionBase.hasAttribute(tag, attrName) || XmlExtension.getExtension(tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, attrName)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement insertRequiredAttributeIntention = isOnTheFly ? XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, attrName, new String[0]) : null;
                String localizedMessage = XmlErrorMessages.message("element.doesnt.have.required.attribute", name, attrName);
                this.reportOneTagProblem(tag, attrName, localizedMessage, insertRequiredAttributeIntention, holder, RequiredAttributesInspectionBase.getIntentionAction(attrName));
            }
        }
    }

    private static boolean hasAttribute(XmlTag tag, String attrName) {
        XmlAttribute attribute = tag.getAttribute(attrName);
        if (attribute == null) {
            return false;
        }
        if (attribute.getValueElement() != null) {
            return true;
        }
        if (!(tag instanceof HtmlTag)) {
            return false;
        }
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, tag);
    }

    private void reportOneTagProblem(XmlTag tag, String name, @NotNull String localizedMessage, LocalQuickFix basicIntention, ProblemsHolder holder, LocalQuickFix addAttributeFix) {
        ProblemHighlightType highlightType;
        LocalQuickFix[] fixes;
        if (localizedMessage == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(5);
        }
        boolean htmlTag = false;
        if (tag instanceof HtmlTag) {
            htmlTag = true;
            if (RequiredAttributesInspectionBase.isAdditionallyDeclared(this.getAdditionalEntries(), name)) {
                return;
            }
        }
        if (htmlTag) {
            LocalQuickFix[] localQuickFixArray;
            if (basicIntention == null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = addAttributeFix;
            } else {
                LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
                localQuickFixArray3[0] = addAttributeFix;
                localQuickFixArray = localQuickFixArray3;
                localQuickFixArray3[1] = basicIntention;
            }
            fixes = localQuickFixArray;
            highlightType = XmlHighlightVisitor.isInjectedWithoutValidation(tag) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        } else {
            LocalQuickFix[] localQuickFixArray;
            if (basicIntention == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray4;
                localQuickFixArray4[0] = basicIntention;
            }
            fixes = localQuickFixArray;
            highlightType = ProblemHighlightType.ERROR;
        }
        RequiredAttributesInspectionBase.addElementsForTag(tag, localizedMessage, highlightType, holder, fixes);
    }

    private static void addElementsForTag(XmlTag tag, String message, ProblemHighlightType error, ProblemsHolder holder, LocalQuickFix ... fixes) {
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getStartTagNameElement(tag), fixes);
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getEndTagNameElement(tag), fixes);
    }

    private static void registerProblem(String message, ProblemHighlightType error, ProblemsHolder holder, XmlToken start, LocalQuickFix[] fixes) {
        if (start != null) {
            holder.registerProblem((PsiElement)start, message, error, fixes);
        }
    }

    private static boolean isAdditionallyDeclared(String additional, String name) {
        if (!additional.contains(name = name.toLowerCase())) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(additional, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportOneTagProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

