/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import org.jetbrains.annotations.NotNull;

public class AdjustPackageNameFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix");
    private final String myName;

    public AdjustPackageNameFix(String targetPackage) {
        this.myName = targetPackage;
    }

    @Override
    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("adjust.package.text", this.myName);
        if (string == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("adjust.package.family", new Object[0]);
        if (string == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AdjustPackageNameFix.$$$reportNull$$$0(3);
        }
        if ((element = descriptor.getPsiElement()) == null) {
            return;
        }
        PsiFile myFile = element.getContainingFile();
        PsiDirectory directory = myFile.getContainingDirectory();
        if (directory == null) {
            return;
        }
        PsiPackage myTargetPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (myTargetPackage == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(myFile.getProject()).getElementFactory();
        PsiPackageStatement myStatement = ((PsiJavaFile)myFile).getPackageStatement();
        if (myTargetPackage.getQualifiedName().length() == 0) {
            if (myStatement != null) {
                myStatement.delete();
            }
        } else {
            PsiPackageStatement packageStatement = factory.createPackageStatement(myTargetPackage.getQualifiedName());
            if (myStatement != null) {
                myStatement.getPackageReference().replace(packageStatement.getPackageReference());
            } else {
                myFile.addAfter(packageStatement, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

