/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.ui.ExternalizableStringSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EmptyClassInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean ignoreClassWithParameterization = false;
    public boolean ignoreThrowables = true;
    public boolean commentsAreContent = true;

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            EmptyClassInspectionBase.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "commentsAreContent");
        this.writeBooleanOption(node, "commentsAreContent", false);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.class.display.name", new Object[0]);
        if (string == null) {
            EmptyClassInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object element = infos[0];
        if (element instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("empty.anonymous.class.problem.descriptor", new Object[0]);
            if (string == null) {
                EmptyClassInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (element instanceof PsiClass) {
            String string = InspectionGadgetsBundle.message("empty.class.problem.descriptor", new Object[0]);
            if (string == null) {
                EmptyClassInspectionBase.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("empty.class.file.without.class.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyClassInspectionBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Object info = infos[0];
        if (!(info instanceof PsiModifierListOwner)) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                EmptyClassInspectionBase.$$$reportNull$$$0(5);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)info, this.ignorableAnnotations);
        if (inspectionGadgetsFixArray == null) {
            EmptyClassInspectionBase.$$$reportNull$$$0(6);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/classlayout/EmptyClassInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/classlayout/EmptyClassInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EmptyClassVisitor
    extends BaseInspectionVisitor {
        private EmptyClassVisitor() {
        }

        @Override
        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            if (javaFile.getClasses().length != 0) {
                return;
            }
            String fileName = javaFile.getName();
            if ("package-info.java".equals(fileName)) {
                return;
            }
            this.registerError((PsiElement)file, file);
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                EmptyClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            if (FileTypeUtils.isInServerPageFile(aClass.getContainingFile())) {
                return;
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                for (PsiClass superClass : aClass.getSupers()) {
                    if (!superClass.isInterface() && !superClass.hasModifierProperty("abstract")) continue;
                    return;
                }
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length > 0) {
                return;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (EmptyClassInspectionBase.this.commentsAreContent && PsiTreeUtil.getChildOfType(aClass, PsiComment.class) != null) {
                return;
            }
            if (EmptyClassInspectionBase.this.ignoreClassWithParameterization && this.isSuperParametrization(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated(aClass, EmptyClassInspectionBase.this.ignorableAnnotations)) {
                return;
            }
            if (EmptyClassInspectionBase.this.ignoreThrowables && InheritanceUtil.isInheritor(aClass, "java.lang.Throwable")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private boolean hasTypeArguments(PsiReferenceList extendsList) {
            PsiJavaCodeReferenceElement[] referenceElements;
            if (extendsList == null) {
                return false;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                PsiType[] typeArguments;
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList == null || (typeArguments = parameterList.getTypeArguments()).length == 0) continue;
                return true;
            }
            return false;
        }

        private boolean isSuperParametrization(PsiClass aClass) {
            PsiTypeElement[] elements;
            if (!(aClass instanceof PsiAnonymousClass)) {
                PsiReferenceList extendsList = aClass.getExtendsList();
                PsiReferenceList implementsList = aClass.getImplementsList();
                return this.hasTypeArguments(extendsList) || this.hasTypeArguments(implementsList);
            }
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            PsiJavaCodeReferenceElement reference = anonymousClass.getBaseClassReference();
            PsiReferenceParameterList parameterList = reference.getParameterList();
            if (parameterList == null) {
                return false;
            }
            for (PsiTypeElement element : elements = parameterList.getTypeParameterElements()) {
                if (element == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/EmptyClassInspectionBase$EmptyClassVisitor", "visitClass"));
        }
    }
}

