/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonBooleanMethodNameMayNotStartWithQuestionInspectionBase
extends BaseInspection {
    @NonNls
    public String questionString = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    public boolean ignoreBooleanMethods = false;
    public boolean onlyWarnOnBaseMethods = true;
    List<String> questionList = new ArrayList<String>(32);

    public NonBooleanMethodNameMayNotStartWithQuestionInspectionBase() {
        NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.display.name", new Object[0]);
        if (string == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.$$$reportNull$$$0(3);
        }
        this.questionString = NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonBooleanMethodNameMayNotStartWithQuestionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NonBooleanMethodNameMayNotStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private NonBooleanMethodNameMayNotStartWithQuestionVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonBooleanMethodNameMayNotStartWithQuestionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (returnType == null || returnType.equals(PsiType.BOOLEAN)) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean")) {
                return;
            }
            String name = method.getName();
            boolean startsWithQuestionWord = false;
            for (String question : NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.this.questionList) {
                if (!name.startsWith(question)) continue;
                if (name.length() == question.length()) {
                    startsWithQuestionWord = true;
                    break;
                }
                char nextChar = name.charAt(question.length());
                if (!Character.isUpperCase(nextChar) && nextChar != '_') continue;
                startsWithQuestionWord = true;
                break;
            }
            if (!startsWithQuestionWord) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase$NonBooleanMethodNameMayNotStartWithQuestionVisitor", "visitMethod"));
        }
    }
}

