/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final SimpleModificationTracker myTracker;

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        this.myTracker = new SimpleModificationTracker();
        this.myClass = aClass;
    }

    @NotNull
    private static <T> T[] copy(T[] value) {
        Object[] objectArray = value.length == 0 ? value : (Object[])value.clone();
        if (objectArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(PsiImplUtil.getConstructors(this.myClass), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker)));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getAllFields(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker)));
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getAllMethods(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker)));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = (PsiClass[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getAllInnerClasses(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker)));
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name, true);
        }
        return (PsiField)((Map)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getFieldsMap(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker))).get(name);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, true);
            if (psiMethodArray == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] methods = (PsiMethod[])((Map)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getMethodsMap(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker))).get(name);
        PsiMethod[] psiMethodArray = methods == null ? PsiMethod.EMPTY_ARRAY : (PsiMethod[])methods.clone();
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getCachedValue(this.myClass, () -> CachedValueProvider.Result.create(this.getInnerClassesMap(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker))).get(name);
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return !this.myClass.isEnum() || this.myClass.getName() == null ? null : (PsiMethod)CachedValuesManager.getCachedValue(this.myClass, () -> {
            String text = "public static " + this.myClass.getName() + "[] values() { }";
            return new CachedValueProvider.Result<PsiMethod>(this.getSyntheticMethod(text), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker);
        });
    }

    @Nullable
    public PsiMethod getValueOfMethod() {
        return !this.myClass.isEnum() || this.myClass.getName() == null ? null : (PsiMethod)CachedValuesManager.getCachedValue(this.myClass, () -> {
            String text = "public static " + this.myClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }";
            return new CachedValueProvider.Result<PsiMethod>(this.getSyntheticMethod(text), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker);
        });
    }

    @NotNull
    private PsiField[] getAllFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List<PsiField> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiField.class);
        PsiField[] psiFieldArray = ArrayUtil.mergeCollections(own, ext, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    private PsiMethod[] getAllMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List<PsiMethod> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class);
        PsiMethod[] psiMethodArray = ArrayUtil.mergeCollections(own, ext, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    @NotNull
    private PsiClass[] getAllInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List<PsiClass> ext = PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class);
        PsiClass[] psiClassArray = ArrayUtil.mergeCollections(own, ext, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            Map<String, PsiField> map = Collections.emptyMap();
            if (map == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(11);
            }
            return map;
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields) {
            String name = field.getName();
            if (cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        THashMap tHashMap = cachedFields;
        if (tHashMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(12);
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            Map<String, PsiMethod[]> map = Collections.emptyMap();
            if (map == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(13);
            }
            return map;
        }
        HashMap collectedMethods = ContainerUtil.newHashMap();
        for (PsiMethod method : methods) {
            List list = (List)collectedMethods.get(method.getName());
            if (list == null) {
                list = ContainerUtil.newSmartList();
                collectedMethods.put(method.getName(), list);
            }
            list.add(method);
        }
        THashMap cachedMethods = ContainerUtil.newTroveMap();
        for (Map.Entry entry : collectedMethods.entrySet()) {
            List list = (List)entry.getValue();
            cachedMethods.put(entry.getKey(), list.toArray(new PsiMethod[list.size()]));
        }
        THashMap tHashMap = cachedMethods;
        if (tHashMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(14);
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes = this.getInnerClasses();
        if (classes.length == 0) {
            Map<String, PsiClass> map = Collections.emptyMap();
            if (map == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(15);
            }
            return map;
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes) {
            String name = psiClass.getName();
            if (name == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error(psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        THashMap tHashMap = cachedInners;
        if (tHashMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(16);
        }
        return tHashMap;
    }

    private PsiMethod getSyntheticMethod(String text) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.myClass.getProject()).getElementFactory();
        PsiMethod method = factory.createMethodFromText(text, this.myClass);
        return new LightMethod(this.myClass.getManager(), method, this.myClass){

            @Override
            public int getTextOffset() {
                return ClassInnerStuffCache.this.myClass.getTextOffset();
            }
        };
    }

    public void dropCaches() {
        this.myTracker.incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

