/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl");
    private final Map<Class<?>, SimpleProviderBinding> myBindingsMap = ContainerUtil.newTroveMap();
    private final Map<Class<?>, NamedObjectProviderBinding> myNamedBindingsMap = ContainerUtil.newTroveMap();
    private final ConcurrentMap<Class, ProviderBinding[]> myBindingCache = ConcurrentFactoryMap.createMap(key -> {
        List<ProviderBinding> result = ContainerUtil.newSmartList();
        for (Class<?> bindingClass : this.myBindingsMap.keySet()) {
            if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
            result.add(this.myBindingsMap.get(bindingClass));
        }
        for (Class<?> bindingClass : this.myNamedBindingsMap.keySet()) {
            if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
            result.add(this.myNamedBindingsMap.get(bindingClass));
        }
        return result.toArray(new ProviderBinding[result.size()]);
    });
    private boolean myInitialized;

    @Deprecated
    public PsiReferenceRegistrarImpl(Language language) {
        this();
    }

    PsiReferenceRegistrarImpl() {
    }

    public void markInitialized() {
        this.myInitialized = true;
    }

    @Override
    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        SimpleProviderBinding providerBinding;
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(1);
        }
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        Class<T> scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List<PatternCondition<T>> conditions = pattern.getCondition().getConditions();
        for (PatternCondition<T> _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List<PatternCondition<String>> conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition<String> condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection<String> strings = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtil.toStringArray(strings), nameCondition, scope, true, provider, priority, pattern);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings, nameCondition, scope, false, provider, priority, pattern);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope, providerBinding);
        }
        providerBinding.registerProvider(provider, pattern, priority);
        this.myBindingCache.clear();
    }

    public void unregisterReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(3);
        }
        this.myBindingsMap.get(scope).unregisterProvider(provider);
    }

    /*
     * WARNING - void declaration
     */
    private void registerNamedReferenceProvider(@NotNull String[] names, final PsiNamePatternCondition<?> nameCondition, @NotNull Class scopeClass, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority, @NotNull ElementPattern elementPattern) {
        void pattern;
        NamedObjectProviderBinding providerBinding;
        if (names == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (scopeClass == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (elementPattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(7);
        }
        if ((providerBinding = this.myNamedBindingsMap.get(scopeClass)) == null) {
            providerBinding = new NamedObjectProviderBinding(){

                @Override
                protected String getName(@NotNull PsiElement position) {
                    if (position == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return nameCondition.getPropertyValue(position);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl$1", "getName"));
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names, (ElementPattern)pattern, caseSensitive, provider, priority);
    }

    public void registerReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(9);
        }
        this.registerReferenceProvider(PlatformPatterns.psiElement(scope), provider, 0.0);
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<ProcessingContext>> getPairsByElement(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        ProviderBinding[] bindings;
        if (element == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(10);
        }
        if (hints == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(11);
        }
        if ((bindings = (ProviderBinding[])this.myBindingCache.get(element.getClass())).length == 0) {
            List<ProviderBinding.ProviderInfo<ProcessingContext>> list = Collections.emptyList();
            if (list == null) {
                PsiReferenceRegistrarImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<ProviderBinding.ProviderInfo<ProcessingContext>> ret = ContainerUtil.newSmartList();
        for (ProviderBinding binding : bindings) {
            binding.addAcceptableReferenceProviders(element, ret, hints);
        }
        List<ProviderBinding.ProviderInfo<ProcessingContext>> list = ret;
        if (list == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairsByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterReferenceProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerNamedReferenceProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPairsByElement";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

