/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.HighlightInfo");
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    JComponent fileLevelComponent;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    private int group;
    public final int startOffset;
    public final int endOffset;
    private int fixStartOffset;
    private int fixEndOffset;
    RangeMarker fixMarker;
    private final String description;
    private final String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    final int navigationShift;
    private volatile RangeHighlighterEx highlighter;
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    private volatile byte myFlags;
    private static final byte BIJECTIVE_MASK = 1;
    private static final byte HAS_HINT_MASK = 2;
    private static final byte FROM_INJECTION_MASK = 4;
    private static final byte AFTER_END_OF_LINE_MASK = 8;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 16;
    private static final byte NEEDS_UPDATE_ON_TYPING_MASK = 32;
    PsiElement psiElement;
    private static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";

    @NotNull
    ProperTextRange getFixTextRange() {
        ProperTextRange properTextRange = new ProperTextRange(this.fixStartOffset, this.fixEndOffset);
        if (properTextRange == null) {
            HighlightInfo.$$$reportNull$$$0(0);
        }
        return properTextRange;
    }

    void setFromInjection(boolean fromInjection) {
        this.setFlag((byte)4, fromInjection);
    }

    @Nullable
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null || description == null || !toolTip.contains(DESCRIPTION_PLACEHOLDER)) {
            return toolTip;
        }
        String decoded = StringUtil.replace(toolTip, DESCRIPTION_PLACEHOLDER, XmlStringUtil.escapeString(description));
        return XmlStringUtil.wrapInHtml(decoded);
    }

    private static String encodeTooltip(String toolTip, String description) {
        String encoded;
        if (toolTip == null || description == null) {
            return toolTip;
        }
        String unescaped = StringUtil.unescapeXml(XmlStringUtil.stripHtml(toolTip));
        String string = encoded = description.isEmpty() ? unescaped : StringUtil.replace(unescaped, description, DESCRIPTION_PLACEHOLDER);
        if (encoded == unescaped) {
            return toolTip;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return encoded;
    }

    public String getDescription() {
        return this.description;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value);
    }

    boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)16);
    }

    boolean isBijective() {
        return this.isFlagSet((byte)1);
    }

    void setBijective(boolean bijective) {
        this.setFlag((byte)1, bijective);
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            HighlightInfo.$$$reportNull$$$0(1);
        }
        return highlightSeverity;
    }

    public RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(@Nullable RangeHighlighterEx highlighter) {
        this.highlighter = highlighter;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)8);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element, this.type, colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        SeverityRegistrar severityRegistrar;
        TextAttributes textAttributes;
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(2);
        }
        if (colorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(3);
        }
        if ((textAttributes = (severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element != null ? element.getProject() : null)).getTextAttributesBySeverity(type.getSeverity(element))) != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    Color getErrorStripeMarkColor(@NotNull PsiElement element, @Nullable EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element == null) {
            HighlightInfo.$$$reportNull$$$0(4);
        }
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type, scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        if (customScheme != null) {
            EditorColorsScheme editorColorsScheme = customScheme;
            if (editorColorsScheme == null) {
                HighlightInfo.$$$reportNull$$$0(5);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(6);
        }
        return editorColorsScheme;
    }

    @Nullable
    @NonNls
    private static String htmlEscapeToolTip(@Nullable String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(unescapedTooltip));
    }

    boolean needUpdateOnTyping() {
        return this.isFlagSet((byte)32);
    }

    protected HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable String escapedDescription, @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, ProblemGroup problemGroup, GutterMark gutterIconRenderer) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(7);
        }
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(8);
        }
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + escapedDescription + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixStartOffset = startOffset;
        this.fixEndOffset = endOffset;
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.setFlag((byte)8, afterEndOfLine);
        this.setFlag((byte)32, HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type));
        this.setFlag((byte)16, isFileLevelAnnotation);
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type instanceof HighlightInfoType.UpdateOnTypingSuppressible) {
            return ((HighlightInfoType.UpdateOnTypingSuppressible)((Object)type)).needsUpdateOnTyping();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return info.getSeverity() == this.getSeverity() && info.startOffset == this.startOffset && info.endOffset == this.endOffset && Comparing.equal(info.type, this.type) && Comparing.equal(info.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info.getDescription(), this.getDescription());
    }

    protected boolean equalsByActualOffset(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(9);
        }
        if (info == this) {
            return true;
        }
        return info.getSeverity() == this.getSeverity() && info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal(info.type, this.type) && Comparing.equal(info.gutterIconRenderer, this.gutterIconRenderer) && Comparing.equal(info.forcedTextAttributes, this.forcedTextAttributes) && Comparing.equal(info.forcedTextAttributesKey, this.forcedTextAttributesKey) && Comparing.strEqual(info.getDescription(), this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    @NonNls
    public String toString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.highlighter != null) {
            s = s + " text='" + this.getText() + "'";
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + " severity=" + this.getSeverity();
        s = s + " group=" + this.getGroup();
        if (this.quickFixActionRanges != null) {
            s = s + "; quickFixes: " + this.quickFixActionRanges;
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + this.gutterIconRenderer;
        }
        return s;
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(10);
        }
        B b = new B(type);
        if (b == null) {
            HighlightInfo.$$$reportNull$$$0(11);
        }
        return b;
    }

    void setGroup(int group) {
        this.group = group;
    }

    private static boolean isAcceptedByFilters(@NotNull HighlightInfo info, @Nullable PsiElement psiElement) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(12);
        }
        PsiFile file = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter : Holder.FILTERS) {
            if (filter.accept(info, file)) continue;
            return false;
        }
        info.psiElement = psiElement;
        return true;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(13);
        }
        HighlightInfo highlightInfo = HighlightInfo.fromAnnotation(annotation, null, false);
        if (highlightInfo == null) {
            HighlightInfo.$$$reportNull$$$0(14);
        }
        return highlightInfo;
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Annotation annotation, @Nullable TextRange fixedRange, boolean batchMode) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(15);
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null ? (key == HighlighterColors.NO_HIGHLIGHTING ? null : key) : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), fixedRange != null ? fixedRange.getStartOffset() : annotation.getStartOffset(), fixedRange != null ? fixedRange.getEndOffset() : annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), annotation.getGutterIconRenderer());
        HighlightInfo.appendFixes(fixedRange, info, batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes());
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            HighlightInfo.$$$reportNull$$$0(16);
        }
        return highlightInfo;
    }

    private static void appendFixes(@Nullable TextRange fixedRange, @NotNull HighlightInfo info, @Nullable List<Annotation.QuickFixInfo> fixes) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(17);
        }
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                TextRange range = fixedRange != null ? fixedRange : quickFixInfo.textRange;
                HighlightDisplayKey key = quickFixInfo.key != null ? quickFixInfo.key : HighlightDisplayKey.find(ANNOTATOR_INSPECTION_SHORT_NAME);
                info.registerFix(quickFixInfo.quickFix, null, HighlightDisplayKey.getDisplayNameByKey(key), range, key);
            }
        }
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        ProblemHighlightType type;
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(18);
        }
        if ((type = annotation.getHighlightType()) == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(19);
            }
            return highlightInfoType;
        }
        if (type == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(20);
            }
            return highlightInfoType;
        }
        if (type == ProblemHighlightType.LIKE_DEPRECATED) {
            HighlightInfoType highlightInfoType = HighlightInfoType.DEPRECATED;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(21);
            }
            return highlightInfoType;
        }
        if (type == ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.MARKED_FOR_REMOVAL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(22);
            }
            return highlightInfoType;
        }
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity(annotation.getSeverity());
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(23);
        }
        return highlightInfoType;
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(24);
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(25);
        }
        return highlightInfoType;
    }

    @NotNull
    public static ProblemHighlightType convertType(HighlightInfoType infoType) {
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.ERROR;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(26);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.WARNING) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(27);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(28);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(29);
        }
        return problemHighlightType;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(HighlightSeverity severity) {
        ProblemHighlightType problemHighlightType = severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(30);
        }
        return problemHighlightType;
    }

    public boolean hasHint() {
        return this.isFlagSet((byte)2);
    }

    void setHint(boolean hasHint) {
        this.setFlag((byte)2, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    int getGroup() {
        return this.group;
    }

    boolean isFromInjection() {
        return this.isFlagSet((byte)4);
    }

    @NotNull
    public String getText() {
        if (this.isFileLevelAnnotation()) {
            if ("" == null) {
                HighlightInfo.$$$reportNull$$$0(31);
            }
            return "";
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        if (!highlighter.isValid()) {
            if ("" == null) {
                HighlightInfo.$$$reportNull$$$0(32);
            }
            return "";
        }
        String string = highlighter.getDocument().getText(TextRange.create(highlighter));
        if (string == null) {
            HighlightInfo.$$$reportNull$$$0(33);
        }
        return string;
    }

    public void registerFix(@Nullable IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(this.startOffset, this.endOffset);
        }
        if (this.quickFixActionRanges == null) {
            this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        IntentionActionDescriptor desc = new IntentionActionDescriptor(action, options, displayName, null, key, this.getProblemGroup(), this.getSeverity());
        this.quickFixActionRanges.add(Pair.create(desc, fixRange));
        this.fixStartOffset = Math.min(this.fixStartOffset, fixRange.getStartOffset());
        this.fixEndOffset = Math.max(this.fixEndOffset, fixRange.getEndOffset());
        if (action instanceof HintAction) {
            this.setHint(true);
        }
    }

    public void unregisterQuickFix(@NotNull Condition<IntentionAction> condition) {
        if (condition == null) {
            HighlightInfo.$$$reportNull$$$0(34);
        }
        this.quickFixActionRanges.removeIf(pair -> {
            if (condition == null) {
                HighlightInfo.$$$reportNull$$$0(35);
            }
            return condition.value(((IntentionActionDescriptor)pair.first).getAction());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newHighlightInfo";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverity";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverityToProblemHighlight";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeMarkColor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsByActualOffset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newHighlightInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByFilters";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendFixes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverity";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unregisterQuickFix";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$unregisterQuickFix$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile List<IntentionAction> myOptions;
        private volatile HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;

        IntentionActionDescriptor(@NotNull IntentionAction action, List<IntentionAction> options, String displayName) {
            if (action == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(0);
            }
            this(action, options, displayName, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, Icon icon) {
            if (action == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(1);
            }
            this(action, null, null, icon);
        }

        IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon) {
            if (action == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(2);
            }
            this(action, options, displayName, icon, null, null, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable List<IntentionAction> options, @Nullable String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            if (action == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(3);
            }
            this.myAction = action;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(4);
            }
            return intentionAction;
        }

        boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        boolean canCleanup(@NotNull PsiElement element) {
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(5);
            }
            if (this.myCanCleanup == null) {
                InspectionToolWrapper toolWrapper;
                InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
                HighlightDisplayKey key = this.myKey;
                this.myCanCleanup = key == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile2.getInspectionTool(key.toString(), element)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<IntentionAction> getOptions(@NotNull PsiElement element, @Nullable Editor editor) {
            HighlightDisplayKey idkey;
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(6);
            }
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                return null;
            }
            List<IntentionAction> options = this.myOptions;
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById(problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if (options != null || key == null) {
                return options;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            List<IntentionAction> newOptions = intentionManager.getStandardIntentionOptions(key, element);
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
            InspectionToolWrapper toolWrapper = profile2.getInspectionTool(key.toString(), element);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) && (idkey = HighlightDisplayKey.findById(key.toString())) != null) {
                toolWrapper = profile2.getInspectionTool(idkey.toString(), element);
            }
            if (toolWrapper != null) {
                Object wrappedTool;
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                Object t = wrappedTool = toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)toolWrapper).getTool() : ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                if (wrappedTool instanceof DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection) {
                    List<IntentionAction> actions = Collections.emptyList();
                    if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                        actions = Arrays.asList(((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            return Collections.singletonList(fixAllIntention);
                        }
                        actions = new ArrayList<IntentionAction>(actions);
                        actions.add(fixAllIntention);
                    }
                    return actions;
                }
                ContainerUtil.addIfNotNull(newOptions, fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    SuppressIntentionAction[] suppressActions = ((CustomSuppressableInspectionTool)wrappedTool).getSuppressActions(element);
                    if (suppressActions != null) {
                        ContainerUtil.addAll(newOptions, suppressActions);
                    }
                } else {
                    SuppressQuickFix[] suppressFixes = ((InspectionProfileEntry)wrappedTool).getBatchSuppressActions(element);
                    if (suppressFixes.length > 0) {
                        ContainerUtil.addAll(newOptions, ContainerUtil.map(suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                SuppressIntentionAction[] suppressActions = ((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element);
                ContainerUtil.addAll(newOptions, suppressActions);
            }
            IntentionActionDescriptor intentionActionDescriptor = this;
            synchronized (intentionActionDescriptor) {
                options = this.myOptions;
                if (options == null) {
                    this.myOptions = options = newOptions;
                }
                this.myKey = null;
            }
            return options;
        }

        @Nullable
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NonNls
        public String toString() {
            String text2 = this.getAction().getText();
            return "descriptor: " + (text2.isEmpty() ? this.getAction().getClass() : text2);
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntentionActionDescriptor && this.myAction.equals(((IntentionActionDescriptor)obj).myAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canCleanup";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class B
    implements Builder {
        private Boolean myNeedsUpdateOnTyping;
        private TextAttributes forcedTextAttributes;
        private TextAttributesKey forcedTextAttributesKey;
        private final HighlightInfoType type;
        private int startOffset;
        private int endOffset;
        private String escapedDescription;
        private String escapedToolTip;
        private HighlightSeverity severity;
        private boolean isAfterEndOfLine;
        private boolean isFileLevelAnnotation;
        private int navigationShift;
        private GutterIconRenderer gutterIconRenderer;
        private ProblemGroup problemGroup;
        private PsiElement psiElement;

        private B(@NotNull HighlightInfoType type) {
            if (type == null) {
                B.$$$reportNull$$$0(0);
            }
            this.startOffset = -1;
            this.endOffset = -1;
            this.type = type;
        }

        @Override
        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
            if (gutterIconRenderer == null) {
                B.$$$reportNull$$$0(1);
            }
            assert (this.gutterIconRenderer == null) : "gutterIconRenderer already set";
            this.gutterIconRenderer = gutterIconRenderer;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(2);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup problemGroup) {
            if (problemGroup == null) {
                B.$$$reportNull$$$0(3);
            }
            assert (this.problemGroup == null) : "problemGroup already set";
            this.problemGroup = problemGroup;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(4);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder description(@NotNull String description) {
            if (description == null) {
                B.$$$reportNull$$$0(5);
            }
            assert (this.escapedDescription == null) : "description already set";
            this.escapedDescription = description;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(6);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder descriptionAndTooltip(@NotNull String description) {
            if (description == null) {
                B.$$$reportNull$$$0(7);
            }
            Builder builder = this.description(description).unescapedToolTip(description);
            if (builder == null) {
                B.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributes attributes) {
            if (attributes == null) {
                B.$$$reportNull$$$0(9);
            }
            assert (this.forcedTextAttributes == null) : "textattributes already set";
            this.forcedTextAttributes = attributes;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(10);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
            if (attributesKey == null) {
                B.$$$reportNull$$$0(11);
            }
            assert (this.forcedTextAttributesKey == null) : "textattributesKey already set";
            this.forcedTextAttributesKey = attributesKey;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(12);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder unescapedToolTip(@NotNull String unescapedToolTip) {
            if (unescapedToolTip == null) {
                B.$$$reportNull$$$0(13);
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = HighlightInfo.htmlEscapeToolTip(unescapedToolTip);
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(14);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder escapedToolTip(@NotNull String escapedToolTip) {
            if (escapedToolTip == null) {
                B.$$$reportNull$$$0(15);
            }
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = escapedToolTip;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(16);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(int start, int end) {
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = start;
            this.endOffset = end;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(17);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull TextRange textRange) {
            if (textRange == null) {
                B.$$$reportNull$$$0(18);
            }
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = textRange.getStartOffset();
            this.endOffset = textRange.getEndOffset();
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(19);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder range(@NotNull ASTNode node) {
            if (node == null) {
                B.$$$reportNull$$$0(20);
            }
            Builder builder = this.range(node.getPsi());
            if (builder == null) {
                B.$$$reportNull$$$0(21);
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element) {
            if (element == null) {
                B.$$$reportNull$$$0(22);
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element;
            Builder builder = this.range(element.getTextRange());
            if (builder == null) {
                B.$$$reportNull$$$0(23);
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element, int start, int end) {
            if (element == null) {
                B.$$$reportNull$$$0(24);
            }
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element;
            Builder builder = this.range(start, end);
            if (builder == null) {
                B.$$$reportNull$$$0(25);
            }
            return builder;
        }

        @Override
        @NotNull
        public Builder endOfLine() {
            this.isAfterEndOfLine = true;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(26);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder needsUpdateOnTyping(boolean update) {
            assert (this.myNeedsUpdateOnTyping == null) : " needsUpdateOnTyping already set";
            this.myNeedsUpdateOnTyping = update;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(27);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder severity(@NotNull HighlightSeverity severity) {
            if (severity == null) {
                B.$$$reportNull$$$0(28);
            }
            assert (this.severity == null) : " severity already set";
            this.severity = severity;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(29);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder fileLevelAnnotation() {
            this.isFileLevelAnnotation = true;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(30);
            }
            return b;
        }

        @Override
        @NotNull
        public Builder navigationShift(int navigationShift) {
            this.navigationShift = navigationShift;
            B b = this;
            if (b == null) {
                B.$$$reportNull$$$0(31);
            }
            return b;
        }

        @Override
        @Nullable
        public HighlightInfo create() {
            HighlightInfo info = this.createUnconditionally();
            LOG.assertTrue(this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtilRt.find(HighlightSeverity.DEFAULT_SEVERITIES, this.severity) != -1, "Custom type requires not-null element to detect its text attributes");
            if (!HighlightInfo.isAcceptedByFilters(info, this.psiElement)) {
                return null;
            }
            return info;
        }

        @Override
        @NotNull
        public HighlightInfo createUnconditionally() {
            if (this.severity == null) {
                this.severity = this.type.getSeverity(this.psiElement);
            }
            HighlightInfo highlightInfo = new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation, this.navigationShift, this.problemGroup, this.gutterIconRenderer);
            if (highlightInfo == null) {
                B.$$$reportNull$$$0(32);
            }
            return highlightInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gutterIconRenderer";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$B";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemGroup";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unescapedToolTip";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "escapedToolTip";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$B";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "gutterIconRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "problemGroup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "descriptionAndTooltip";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "textAttributes";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unescapedToolTip";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapedToolTip";
                    break;
                }
                case 17: 
                case 19: 
                case 21: 
                case 23: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endOfLine";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "needsUpdateOnTyping";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "severity";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileLevelAnnotation";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigationShift";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUnconditionally";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "gutterIconRenderer";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "problemGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "description";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "descriptionAndTooltip";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "textAttributes";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "unescapedToolTip";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "escapedToolTip";
                    break;
                }
                case 18: 
                case 20: 
                case 22: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "severity";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 21: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @NotNull
        public Builder description(@NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @Nullable(value="null means filtered out")
        public HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();
    }

    private static class Holder {
        private static final HighlightInfoFilter[] FILTERS = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();

        private Holder() {
        }
    }

    private static @interface FlagConstant {
    }
}

