/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleGraphUtil {
    private JavaModuleGraphUtil() {
    }

    @Nullable
    public static PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
        if (element != null) {
            PsiFileSystemItem fsItem;
            PsiFileSystemItem psiFileSystemItem = fsItem = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
            if (fsItem != null) {
                return JavaModuleGraphUtil.findDescriptorByFile(fsItem.getVirtualFile(), fsItem.getProject());
            }
        }
        return null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorByFile(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(0);
        }
        return ModuleHighlightUtil.getModuleDescriptor(file, project);
    }

    @Nullable
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(1);
        }
        Project project = module.getProject();
        List cycles = (List)CachedValuesManager.getManager(project).getCachedValue(project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.findCycles(project), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        return (Collection)((Object)ContainerUtil.find(cycles, set -> {
            if (module == null) {
                JavaModuleGraphUtil.$$$reportNull$$$0(11);
            }
            return set.contains(module);
        }));
    }

    public static boolean exports(@NotNull PsiJavaModule source, @NotNull String packageName, @Nullable PsiJavaModule target) {
        Map exports;
        Set targets;
        if (source == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(3);
        }
        return (targets = (Set)(exports = (Map)CachedValuesManager.getCachedValue(source, () -> {
            if (source == null) {
                JavaModuleGraphUtil.$$$reportNull$$$0(10);
            }
            return CachedValueProvider.Result.create(JavaModuleGraphUtil.exportsMap(source), source.getContainingFile());
        })).get(packageName)) != null && (targets.isEmpty() || target != null && targets.contains(target.getName()));
    }

    public static boolean reads(@NotNull PsiJavaModule source, @NotNull PsiJavaModule destination) {
        if (source == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(4);
        }
        if (destination == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(5);
        }
        return JavaModuleGraphUtil.getRequiresGraph(source).reads(source, destination);
    }

    @Nullable
    public static Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(6);
        }
        return JavaModuleGraphUtil.getRequiresGraph(module).findConflict(module);
    }

    @Nullable
    public static PsiJavaModule findOrigin(@NotNull PsiJavaModule module, @NotNull String packageName) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(7);
        }
        if (packageName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(8);
        }
        return JavaModuleGraphUtil.getRequiresGraph(module).findOrigin(module, packageName);
    }

    private static List<Set<PsiJavaModule>> findCycles(Project project) {
        HashSet<PsiJavaModule> projectModules = ContainerUtil.newHashSet();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            List descriptors = Stream.of(ModuleRootManager.getInstance(module).getSourceRoots(true)).map(root -> JavaModuleGraphUtil.findDescriptorByFile(root, project)).filter(Objects::nonNull).collect(Collectors.toList());
            if (descriptors.size() > 1) {
                return Collections.emptyList();
            }
            if (descriptors.size() != 1) continue;
            projectModules.add((PsiJavaModule)descriptors.get(0));
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph;
            DFSTBuilder builder;
            Collection components;
            MultiMap<PsiJavaModule, PsiJavaModule> relations = MultiMap.create();
            for (PsiJavaModule module : projectModules) {
                for (PsiRequiresStatement statement : module.getRequires()) {
                    PsiJavaModule dependency = PsiJavaModuleReference.resolve(statement, statement.getModuleName(), true);
                    if (dependency == null || !projectModules.contains(dependency)) continue;
                    relations.putValue(module, dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                return components.stream().map(ContainerUtil::newLinkedHashSet).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source) {
        if (source == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(9);
        }
        HashMap<String, Set<String>> map = ContainerUtil.newHashMap();
        for (PsiPackageAccessibilityStatement statement : source.getExports()) {
            String pkg = statement.getPackageName();
            List<String> targets = statement.getModuleNames();
            map.put(pkg, targets.isEmpty() ? Collections.emptySet() : ContainerUtil.newTroveSet(targets));
        }
        return map;
    }

    private static RequiresGraph getRequiresGraph(PsiJavaModule module) {
        Project project = module.getProject();
        return (RequiresGraph)CachedValuesManager.getManager(project).getCachedValue(project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.buildRequiresGraph(project), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
    }

    private static RequiresGraph buildRequiresGraph(Project project) {
        MultiMap<PsiJavaModule, PsiJavaModule> relations = MultiMap.create();
        THashSet transitiveEdges = ContainerUtil.newTroveSet();
        JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
        GlobalSearchScope scope = ProjectScope.getAllScope(project);
        for (String key : index.getAllKeys(project)) {
            for (PsiJavaModule module : index.get(key, project, scope)) {
                JavaModuleGraphUtil.visit(module, relations, transitiveEdges);
            }
        }
        Graph<PsiJavaModule> graph = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph(graph, (Set<String>)transitiveEdges);
    }

    private static void visit(PsiJavaModule module, MultiMap<PsiJavaModule, PsiJavaModule> relations, Set<String> transitiveEdges) {
        if (!relations.containsKey(module)) {
            PsiJavaModule javaBase;
            relations.putValues(module, Collections.emptyList());
            boolean explicitJavaBase = false;
            for (PsiRequiresStatement statement : module.getRequires()) {
                String moduleName = statement.getModuleName();
                if ("java.base".equals(moduleName)) {
                    explicitJavaBase = true;
                }
                for (PsiJavaModule dependency : PsiJavaModuleReference.multiResolve(statement, moduleName, false)) {
                    relations.putValue(module, dependency);
                    if (statement.hasModifierProperty("transitive")) {
                        transitiveEdges.add(RequiresGraph.key(dependency, module));
                    }
                    JavaModuleGraphUtil.visit(dependency, relations, transitiveEdges);
                }
            }
            if (!explicitJavaBase && !(module instanceof LightJavaModule) && (javaBase = PsiJavaModuleReference.resolve(module, "java.base", false)) != null) {
                relations.putValue(module, javaBase);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findDescriptorByFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findCycle";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "exports";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reads";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflict";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrigin";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "exportsMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$exports$2";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findCycle$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new THashSet();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        public ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        @Override
        public Collection<N> getNodes() {
            return this.myNodes;
        }

        @Override
        public Iterator<N> getIn(N n) {
            return this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
        }

        @Override
        public Iterator<N> getOut(N n) {
            return this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
        }
    }

    private static class RequiresGraph {
        private final Graph<PsiJavaModule> myGraph;
        private final Set<String> myTransitiveEdges;

        public RequiresGraph(Graph<PsiJavaModule> graph, Set<String> transitiveEdges) {
            this.myGraph = graph;
            this.myTransitiveEdges = transitiveEdges;
        }

        public boolean reads(PsiJavaModule source, PsiJavaModule destination) {
            Collection<PsiJavaModule> nodes = this.myGraph.getNodes();
            if (nodes.contains(destination) && nodes.contains(source)) {
                Iterator<PsiJavaModule> directReaders = this.myGraph.getOut(destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = directReaders.next();
                    if (!source.equals(next) && (!this.myTransitiveEdges.contains(RequiresGraph.key(destination, next)) || !this.reads(source, next))) continue;
                    return true;
                }
            }
            return false;
        }

        public Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(PsiJavaModule source) {
            HashMap exports = ContainerUtil.newHashMap();
            return this.processExports(source, (pkg, m) -> {
                PsiJavaModule existing = exports.put(pkg, m);
                return existing != null ? new Trinity<String, PsiJavaModule, PsiJavaModule>((String)pkg, existing, (PsiJavaModule)m) : null;
            });
        }

        public PsiJavaModule findOrigin(PsiJavaModule module, String packageName) {
            return this.processExports(module, (pkg, m) -> packageName.equals(pkg) ? m : null);
        }

        private <T> T processExports(PsiJavaModule start, BiFunction<String, PsiJavaModule, T> processor) {
            return this.myGraph.getNodes().contains(start) ? (T)this.processExports(start.getName(), start, 0, ContainerUtil.newHashSet(), processor) : null;
        }

        private <T> T processExports(String name, PsiJavaModule module, int layer, Set<PsiJavaModule> visited, BiFunction<String, PsiJavaModule, T> processor) {
            if (visited.add(module)) {
                if (layer == 1) {
                    for (PsiPackageAccessibilityStatement statement : module.getExports()) {
                        T result;
                        List<String> exportTargets = statement.getModuleNames();
                        if (!exportTargets.isEmpty() && !exportTargets.contains(name) || (result = processor.apply(statement.getPackageName(), module)) == null) continue;
                        return result;
                    }
                }
                if (layer < 2) {
                    Iterator<PsiJavaModule> iterator = this.myGraph.getIn(module);
                    while (iterator.hasNext()) {
                        T result;
                        PsiJavaModule dependency = iterator.next();
                        if (layer != 0 && !this.myTransitiveEdges.contains(RequiresGraph.key(dependency, module)) || (result = this.processExports(name, dependency, 1, visited, processor)) == null) continue;
                        return result;
                    }
                }
            }
            return null;
        }

        public static String key(PsiJavaModule module, PsiJavaModule exporter) {
            return module.getName() + '/' + exporter.getName();
        }
    }
}

