/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertLineSeparatorsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeStyle.AbstractConvertLineSeparatorsAction");
    @NotNull
    private final String mySeparator;

    protected AbstractConvertLineSeparatorsAction(@Nullable String text2, @NotNull LineSeparator separator) {
        if (separator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(0);
        }
        this((Object)((Object)separator) + " - " + text2, separator.getSeparatorString());
    }

    protected AbstractConvertLineSeparatorsAction(@Nullable String text2, @NotNull String separator) {
        if (separator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(1);
        }
        super(text2);
        this.mySeparator = separator;
    }

    @Override
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            VirtualFile[] virtualFiles = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            Presentation presentation = e.getPresentation();
            if (virtualFiles != null) {
                if (virtualFiles.length == 1) {
                    presentation.setEnabled(!this.mySeparator.equals(LoadTextUtil.detectLineSeparator(virtualFiles[0], false)));
                } else {
                    presentation.setEnabled(true);
                }
            } else {
                presentation.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        final Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        VirtualFile[] virtualFiles = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles == null) {
            return;
        }
        final VirtualFile projectVirtualDirectory = ProjectKt.getStateStore(project).getDirectoryStoreFile();
        final FileTypeRegistry fileTypeManager = FileTypeRegistry.getInstance();
        for (VirtualFile file : virtualFiles) {
            VfsUtilCore.visitChildrenRecursively(file, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                @Override
                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (AbstractConvertLineSeparatorsAction.shouldProcess(file, project)) {
                        AbstractConvertLineSeparatorsAction.changeLineSeparators(project, file, AbstractConvertLineSeparatorsAction.this.mySeparator);
                    }
                    VirtualFileVisitor.Result result = file.isDirectory() && (file.equals(projectVirtualDirectory) || fileTypeManager.isFileIgnored(file)) ? SKIP_CHILDREN : CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }

    public static boolean shouldProcess(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(3);
        }
        if (file.isDirectory() || !file.isWritable() || FileTypeRegistry.getInstance().isFileIgnored(file) || file.getFileType().isBinary() || file.equals(project.getProjectFile()) || file.equals(project.getWorkspaceFile())) {
            return false;
        }
        Module module = FileIndexFacade.getInstance(project).getModuleForFile(file);
        return module == null || !ModuleUtilCore.isModuleFile(module, file);
    }

    public static void changeLineSeparators(final @NotNull Project project, final @NotNull VirtualFile virtualFile, final @NotNull String newSeparator) {
        String currentSeparator;
        FileDocumentManager fileDocumentManager;
        Document document;
        if (project == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(5);
        }
        if (newSeparator == null) {
            AbstractConvertLineSeparatorsAction.$$$reportNull$$$0(6);
        }
        if ((document = (fileDocumentManager = FileDocumentManager.getInstance()).getCachedDocument(virtualFile)) != null) {
            fileDocumentManager.saveDocument(document);
        }
        String commandText = StringUtil.isEmpty(currentSeparator = LoadTextUtil.detectLineSeparator(virtualFile, false)) ? "Changed line separators to " + (Object)((Object)LineSeparator.fromString(newSeparator)) : String.format("Changed line separators from %s to %s", new Object[]{LineSeparator.fromString(currentSeparator), LineSeparator.fromString(newSeparator)});
        new WriteCommandAction(project, commandText, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    LoadTextUtil.changeLineSeparators(project, virtualFile, newSeparator, this);
                }
                catch (IOException e) {
                    LOG.info(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$2", "run"));
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changeLineSeparators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

