/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return null;
    }

    public boolean isShowInExternalLibrariesNode() {
        return this instanceof ItemPresentation;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(1);
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(2);
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(final @NotNull Collection<VirtualFile> sourceRoots, final @NotNull Set<VirtualFile> excludedRoots, final @Nullable Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(3);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(4);
        }
        SyntheticLibrary syntheticLibrary = new SyntheticLibrary(){

            @Override
            @NotNull
            public Collection<VirtualFile> getSourceRoots() {
                Collection collection = sourceRoots;
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @Override
            @NotNull
            public Set<VirtualFile> getExcludedRoots() {
                Set set = excludedRoots;
                if (set == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set;
            }

            @Override
            @Nullable
            public Condition<VirtualFile> getExcludeFileCondition() {
                return excludeCondition;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SyntheticLibrary library = (SyntheticLibrary)o;
                if (!sourceRoots.equals(library.getSourceRoots())) {
                    return false;
                }
                if (!excludedRoots.equals(library.getExcludedRoots())) {
                    return false;
                }
                return !(excludeCondition != null ? !excludeCondition.equals(library.getExcludeFileCondition()) : library.getExcludeFileCondition() != null);
            }

            @Override
            public int hashCode() {
                int result = sourceRoots.hashCode();
                result = 31 * result + excludedRoots.hashCode();
                result = 31 * result + (excludeCondition != null ? excludeCondition.hashCode() : 0);
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/roots/SyntheticLibrary$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSourceRoots";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExcludedRoots";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (syntheticLibrary == null) {
            SyntheticLibrary.$$$reportNull$$$0(5);
        }
        return syntheticLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newImmutableLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newImmutableLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

