/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class ArrayEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.display.name", new Object[0]);
        if (string == null) {
            ArrayEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayEqualsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiArrayType type = (PsiArrayType)infos[0];
        if (type != null && (componentType = type.getComponentType()) instanceof PsiArrayType) {
            return new ArrayEqualsFix(true);
        }
        return new ArrayEqualsFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ArrayEqualsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualsVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ArrayEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (argument == null) {
                return;
            }
            PsiType argumentType = argument.getType();
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression, qualifierType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ArrayEqualsFix
    extends InspectionGadgetsFix {
        private final boolean deepEquals;

        public ArrayEqualsFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.deepEquals) {
                String string = InspectionGadgetsBundle.message("replace.with.arrays.deep.equals", new Object[0]);
                if (string == null) {
                    ArrayEqualsFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
            if (string == null) {
                ArrayEqualsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with Arrays.equals" == null) {
                ArrayEqualsFix.$$$reportNull$$$0(2);
            }
            return "Replace with Arrays.equals";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            assert (expression != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            assert (qualifier != null);
            String qualifierText = qualifier.getText();
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            String argumentText = arguments[0].getText();
            StringBuilder newExpressionText = new StringBuilder();
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(qualifierText);
            newExpressionText.append(", ");
            newExpressionText.append(argumentText);
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(call, newExpressionText.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

