/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NestingDepthVisitor;
import org.jetbrains.annotations.NotNull;

public class NestingDepthInspection
extends MethodMetricInspection {
    @Override
    @NotNull
    public String getID() {
        if ("OverlyNestedMethod" == null) {
            NestingDepthInspection.$$$reportNull$$$0(0);
        }
        return "OverlyNestedMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nesting.depth.display.name", new Object[0]);
        if (string == null) {
            NestingDepthInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("nesting.depth.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer nestingDepth = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("nesting.depth.problem.descriptor", nestingDepth);
        if (string == null) {
            NestingDepthInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestingDepthMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/NestingDepthInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NestingDepthMethodVisitor
    extends BaseInspectionVisitor {
        private NestingDepthMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NestingDepthMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NestingDepthVisitor visitor = new NestingDepthVisitor(NestingDepthInspection.this.getLimit());
            method.accept(visitor);
            int count = visitor.getMaximumDepth();
            if (count <= NestingDepthInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/NestingDepthInspection$NestingDepthMethodVisitor", "visitMethod"));
        }
    }
}

