/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryParenthesesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreClarifyingParentheses = false;
    public boolean ignoreParenthesesOnConditionals = false;
    public boolean ignoreParenthesesOnLambdaParameter = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessary.parentheses.option", new Object[0]), "ignoreClarifyingParentheses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessary.parentheses.conditional.option", new Object[0]), "ignoreParenthesesOnConditionals");
        optionsPanel.addCheckbox("Ignore parentheses around single no formal type lambda parameter", "ignoreParenthesesOnLambdaParameter");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryParenthesesVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryParenthesesFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryParenthesesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryParenthesesVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryParenthesesVisitor() {
        }

        @Override
        public void visitParameterList(PsiParameterList list) {
            PsiParameter parameter;
            super.visitParameterList(list);
            if (!UnnecessaryParenthesesInspection.this.ignoreParenthesesOnLambdaParameter && list.getParent() instanceof PsiLambdaExpression && list.getParametersCount() == 1 && (parameter = list.getParameters()[0]).getTypeElement() == null && list.getFirstChild() != parameter && list.getLastChild() != parameter) {
                this.registerError((PsiElement)list, new Object[0]);
            }
        }

        @Override
        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiConditionalExpression conditionalExpression;
            PsiExpression condition;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (UnnecessaryParenthesesInspection.this.ignoreParenthesesOnConditionals && parent instanceof PsiConditionalExpression && expression == (condition = (conditionalExpression = (PsiConditionalExpression)parent).getCondition())) {
                return;
            }
            if (!ParenthesesUtils.areParenthesesNeeded(expression, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses)) {
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            super.visitParenthesizedExpression(expression);
        }
    }

    private class UnnecessaryParenthesesFix
    extends InspectionGadgetsFix {
        private UnnecessaryParenthesesFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.parentheses.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryParenthesesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiParameterList) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(element.getProject());
                PsiParameterList parameterList = (PsiParameterList)element;
                String text2 = parameterList.getParameters()[0].getName() + "->{}";
                PsiLambdaExpression expression = (PsiLambdaExpression)factory.createExpressionFromText(text2, element);
                element.replace(expression.getParameterList());
            } else {
                ParenthesesUtils.removeParentheses((PsiExpression)element, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryParenthesesInspection$UnnecessaryParenthesesFix", "getFamilyName"));
        }
    }
}

