/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

class ThreadingUtils {
    private ThreadingUtils() {
    }

    public static boolean isWaitCall(@NotNull PsiMethodCallExpression expression) {
        PsiType parameterType;
        PsiReferenceExpression methodExpression;
        String methodName;
        if (expression == null) {
            ThreadingUtils.$$$reportNull$$$0(0);
        }
        if (!"wait".equals(methodName = (methodExpression = expression.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        int numParams = parameterList.getParametersCount();
        if (numParams > 2) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiType.LONG)) {
            return false;
        }
        return numParams <= 1 || (parameterType = parameters[1].getType()).equals(PsiType.INT);
    }

    public static boolean isNotifyOrNotifyAllCall(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        String methodName;
        if (expression == null) {
            ThreadingUtils.$$$reportNull$$$0(1);
        }
        if (!"notify".equals(methodName = (methodExpression = expression.getMethodExpression()).getReferenceName()) && !"notifyAll".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        return args.length == 0;
    }

    public static boolean isSignalOrSignalAllCall(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        String methodName;
        if (expression == null) {
            ThreadingUtils.$$$reportNull$$$0(2);
        }
        if (!"signal".equals(methodName = (methodExpression = expression.getMethodExpression()).getReferenceName()) && !"signalAll".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length != 0) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor(containingClass, "java.util.concurrent.locks.Condition");
    }

    public static boolean isAwaitCall(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        String methodName;
        if (expression == null) {
            ThreadingUtils.$$$reportNull$$$0(3);
        }
        if (!("await".equals(methodName = (methodExpression = expression.getMethodExpression()).getReferenceName()) || "awaitUntil".equals(methodName) || "awaitUninterruptibly".equals(methodName) || "awaitNanos".equals(methodName))) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor(containingClass, "java.util.concurrent.locks.Condition");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/siyeh/ig/threading/ThreadingUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWaitCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotifyOrNotifyAllCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSignalOrSignalAllCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAwaitCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

