/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryModuleDependencyInspection
extends GlobalInspectionTool {
    private SoftReference<Graph<Module>> myGraph = new SoftReference<Object>(null);

    @Override
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(0);
        }
        return new UnnecessaryModuleDependencyAnnotator(refManager);
    }

    @Override
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(4);
        }
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            OrderEntry[] declaredDependencies = moduleRootManager.getOrderEntries();
            Module[] declaredModuleDependencies = moduleRootManager.getDependencies();
            ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
            Set<Module> modules = refModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES);
            Graph<Module> graph = (Graph<Module>)this.myGraph.get();
            if (graph == null) {
                graph = ModuleManager.getInstance(globalContext.getProject()).moduleGraph();
                this.myGraph = new SoftReference<Graph<Module>>(graph);
            }
            RefManager refManager = globalContext.getRefManager();
            for (OrderEntry entry : declaredDependencies) {
                Module dependency;
                if (!(entry instanceof ModuleOrderEntry) || (dependency = ((ModuleOrderEntry)entry).getModule()) == null || modules != null && modules.contains(dependency)) continue;
                ArrayList<String> dependenciesThroughExported = null;
                if (((ModuleOrderEntry)entry).isExported()) {
                    Iterator<Module> iterator = graph.getOut(module);
                    while (iterator.hasNext()) {
                        Set<Module> neededModules;
                        Module dep = iterator.next();
                        RefModule depRefModule = refManager.getRefModule(dep);
                        if (depRefModule == null || (neededModules = depRefModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES)) == null || !neededModules.contains(dependency)) continue;
                        if (dependenciesThroughExported == null) {
                            dependenciesThroughExported = new ArrayList<String>();
                        }
                        dependenciesThroughExported.add(dep.getName());
                    }
                }
                if (modules != null) {
                    ArrayList<String> transitiveDependencies = new ArrayList<String>();
                    OrderEntry[] dependenciesOfDependencies = ModuleRootManager.getInstance(dependency).getOrderEntries();
                    for (OrderEntry secondDependency : dependenciesOfDependencies) {
                        Module mod;
                        if (!(secondDependency instanceof ModuleOrderEntry) || !((ModuleOrderEntry)secondDependency).isExported() || (mod = ((ModuleOrderEntry)secondDependency).getModule()) == null || !modules.contains(mod) || ArrayUtil.find(declaredModuleDependencies, mod) >= 0) continue;
                        transitiveDependencies.add(mod.getName());
                    }
                    if (!transitiveDependencies.isEmpty()) {
                        String exported = StringUtil.join(transitiveDependencies, ", ");
                        descriptors.add(manager.createProblemDescriptor(InspectionsBundle.message("unnecessary.module.dependency.exported.problem.descriptor1", module.getName(), dependency.getName(), exported), new QuickFix[0]));
                        continue;
                    }
                }
                descriptors.add(UnnecessaryModuleDependencyInspection.createDescriptor(scope, manager, module, dependency, dependenciesThroughExported));
            }
            return descriptors.isEmpty() ? null : descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
        }
        return null;
    }

    private static CommonProblemDescriptor createDescriptor(AnalysisScope scope, InspectionManager manager, Module module, Module dependency, List<String> exportedDependencies) {
        if (exportedDependencies != null) {
            String exported = StringUtil.join(exportedDependencies, ", ");
            return manager.createProblemDescriptor(InspectionsBundle.message("unnecessary.module.dependency.exported.problem.descriptor", module.getName(), dependency.getName(), exported), new QuickFix[0]);
        }
        if (scope.containsModule(dependency)) {
            String allContainsMessage = InspectionsBundle.message("unnecessary.module.dependency.problem.descriptor", module.getName(), dependency.getName());
            return manager.createProblemDescriptor(allContainsMessage, new RemoveModuleDependencyFix(module, dependency));
        }
        String message = InspectionsBundle.message("suspected.module.dependency.problem.descriptor", module.getName(), dependency.getName(), scope.getDisplayName());
        return manager.createProblemDescriptor(message, new QuickFix[0]);
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("unnecessary.module.dependency.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("UnnecessaryModuleDependencyInspection" == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(7);
        }
        return "UnnecessaryModuleDependencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemoveModuleDependencyFix
    implements QuickFix {
        private final Module myModule;
        private final Module myDependency;

        public RemoveModuleDependencyFix(Module module, Module dependency) {
            this.myModule = module;
            this.myDependency = dependency;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Remove dependency" == null) {
                RemoveModuleDependencyFix.$$$reportNull$$$0(0);
            }
            return "Remove dependency";
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                RemoveModuleDependencyFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveModuleDependencyFix.$$$reportNull$$$0(2);
            }
            ModifiableRootModel model = ModuleRootManager.getInstance(this.myModule).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                Module mDependency;
                if (!(entry instanceof ModuleOrderEntry) || !Comparing.equal(mDependency = ((ModuleOrderEntry)entry).getModule(), this.myDependency)) continue;
                model.removeOrderEntry(entry);
                break;
            }
            model.commit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

