/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEnumeratedValueReference
extends PsiReferenceBase<XmlElement>
implements EmptyResolveMessageProvider,
ResolvingHint {
    private final XmlEnumerationDescriptor myDescriptor;

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor) {
        super(value);
        this.myDescriptor = descriptor;
    }

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor, TextRange range) {
        super(value, range);
        this.myDescriptor = descriptor;
    }

    @Override
    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(XmlElement.class, elementClass);
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        return this.myDescriptor.getValueDeclaration((XmlElement)this.getElement(), this.getValue());
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (this.myDescriptor.isFixed()) {
            Object[] objectArray;
            String defaultValue = this.myDescriptor.getDefaultValue();
            if (defaultValue == null) {
                objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = defaultValue;
            }
            if (objectArray == null) {
                XmlEnumeratedValueReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        String[] values = this.myDescriptor.getValuesForCompletion();
        Object[] objectArray = values == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : values;
        if (objectArray == null) {
            XmlEnumeratedValueReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String name = this.getElement() instanceof XmlTag ? "tag" : "attribute";
        String string = this.myDescriptor.isFixed() ? XmlErrorMessages.message("should.have.fixed.value", StringUtil.capitalize(name), this.myDescriptor.getDefaultValue()) : XmlErrorMessages.message("wrong.value", name);
        if (string == null) {
            XmlEnumeratedValueReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xml/util/XmlEnumeratedValueReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

