/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodInheritanceUtils;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodReturnAlwaysConstantInspection
extends BaseGlobalInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.return.always.constant.display.name", new Object[0]);
        if (string == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (refMethod.hasSuperMethods()) {
            return null;
        }
        PsiModifierListOwner element = refMethod.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        if (((PsiMethod)element).getBody() == null && refMethod.getDerivedMethods().isEmpty()) {
            return null;
        }
        Set<RefMethod> allScopeInheritors = MethodInheritanceUtils.calculateSiblingMethods(refMethod);
        for (RefMethod siblingMethod : allScopeInheritors) {
            PsiMethod siblingPsiMethod = (PsiMethod)siblingMethod.getElement();
            if (siblingPsiMethod.getBody() == null || MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(siblingPsiMethod)) continue;
            return null;
        }
        ArrayList<ProblemDescriptor> out = new ArrayList<ProblemDescriptor>();
        for (RefMethod siblingRefMethod : allScopeInheritors) {
            PsiMethod siblingMethod = (PsiMethod)siblingRefMethod.getElement();
            PsiIdentifier identifier = siblingMethod.getNameIdentifier();
            if (identifier == null) continue;
            out.add(manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("method.return.always.constant.problem.descriptor", new Object[0]), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        return out.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean alwaysReturnsConstant(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body);
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression value = returnStatement.getReturnValue();
        return value != null && PsiUtil.isConstantExpression(value);
    }

    @Override
    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(5);
        }
        if (globalContext == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            MethodReturnAlwaysConstantInspection.$$$reportNull$$$0(7);
        }
        manager.iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept(new RefJavaVisitor(){

                        @Override
                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                @Override
                                public boolean process(PsiMethod derivedMethod) {
                                    processor.ignoreElement(refMethod);
                                    return false;
                                }
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection$1$1", "visitMethod"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection$1", "visitElement"));
            }
        });
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/classlayout/MethodReturnAlwaysConstantInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

