/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestCaseWithConstructorInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("JUnitTestCaseWithNonTrivialConstructors" == null) {
            TestCaseWithConstructorInspection.$$$reportNull$$$0(0);
        }
        return "JUnitTestCaseWithNonTrivialConstructors";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.with.constructor.display.name", new Object[0]);
        if (string == null) {
            TestCaseWithConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (Boolean.TRUE.equals(infos[0])) {
            String string = InspectionGadgetsBundle.message("test.case.with.constructor.problem.descriptor.initializer", new Object[0]);
            if (string == null) {
                TestCaseWithConstructorInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("test.case.with.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            TestCaseWithConstructorInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/TestCaseWithConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TestCaseWithConstructorVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithConstructorVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                TestCaseWithConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isConstructor()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!TestUtils.isJUnitTestClass(aClass) && !TestUtils.isJUnit4TestClass(aClass, false)) {
                return;
            }
            if (MethodUtils.isTrivial(method, false)) {
                return;
            }
            this.registerMethodError(method, Boolean.FALSE);
        }

        @Override
        public void visitClassInitializer(PsiClassInitializer initializer) {
            if (initializer.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = initializer.getContainingClass();
            if (!TestUtils.isJUnitTestClass(aClass) && !TestUtils.isJUnit4TestClass(aClass, true)) {
                return;
            }
            if (MethodUtils.isTrivial(initializer)) {
                return;
            }
            this.registerClassInitializerError(initializer, Boolean.TRUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestCaseWithConstructorInspection$TestCaseWithConstructorVisitor", "visitMethod"));
        }
    }
}

