/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVarTypeUtil {
    public static PsiType getUpwardProjection(@NotNull PsiType t) {
        if (t == null) {
            JavaVarTypeUtil.$$$reportNull$$$0(0);
        }
        return t.accept(new UpwardProjectionTypeVisitor());
    }

    public static PsiType getDownwardProjection(@NotNull PsiType type) {
        if (type == null) {
            JavaVarTypeUtil.$$$reportNull$$$0(1);
        }
        return type.accept(new DownwardProjectionTypeVisitor());
    }

    private static boolean mentionsRestrictedTypeVariables(PsiType type) {
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(PsiType type) {
                return false;
            }

            @Override
            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/JavaVarTypeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpwardProjection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDownwardProjection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DownwardProjectionTypeVisitor
    extends PsiTypeVisitor<PsiType> {
        private DownwardProjectionTypeVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type) {
            return type;
        }

        @Override
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return capturedWildcardType.getLowerBound().accept(this);
        }

        @Override
        public PsiType visitArrayType(PsiArrayType arrayType) {
            PsiType projection = arrayType.getComponentType().accept(this);
            if (projection == PsiType.NULL) {
                return PsiType.NULL;
            }
            return projection.createArrayType();
        }

        @Override
        public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
            PsiType[] conjuncts = (PsiType[])Arrays.stream(intersectionType.getConjuncts()).map(conjunct -> conjunct.accept(this)).toArray(PsiType[]::new);
            if (ArrayUtil.find(conjuncts, PsiType.NULL) > -1) {
                return PsiType.NULL;
            }
            return PsiIntersectionType.createIntersection(conjuncts);
        }

        @Override
        public PsiType visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return lambdaExpressionType;
        }

        @Override
        public PsiType visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
            return methodReferenceType;
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult result = classType.resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiSubstitutor targetSubstitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType ai = substitutor.substitute(parameter);
                    if (ai == null) {
                        return PsiType.NULL;
                    }
                    if (!JavaVarTypeUtil.mentionsRestrictedTypeVariables(ai)) {
                        targetSubstitutor = targetSubstitutor.put(parameter, ai);
                        continue;
                    }
                    if (ai instanceof PsiWildcardType) {
                        if (((PsiWildcardType)ai).isExtends()) {
                            PsiType extendsBound = ((PsiWildcardType)ai).getExtendsBound();
                            PsiType projection = extendsBound.accept(this);
                            if (projection == PsiType.NULL) {
                                return PsiType.NULL;
                            }
                            targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createExtends(parameter.getManager(), projection));
                            continue;
                        }
                        if (((PsiWildcardType)ai).isSuper()) {
                            PsiType superBound = ((PsiWildcardType)ai).getSuperBound();
                            targetSubstitutor = targetSubstitutor.put(parameter, JavaVarTypeUtil.getUpwardProjection(superBound));
                            continue;
                        }
                        return PsiType.NULL;
                    }
                    return PsiType.NULL;
                }
                return JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory().createType(aClass, targetSubstitutor);
            }
            return PsiType.NULL;
        }
    }

    private static class UpwardProjectionTypeVisitor
    extends PsiTypeVisitorEx<PsiType> {
        private UpwardProjectionTypeVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type) {
            return type;
        }

        @Override
        @Nullable
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return capturedWildcardType.getUpperBound().accept(this);
        }

        @Override
        public PsiType visitArrayType(PsiArrayType arrayType) {
            PsiType componentType = arrayType.getComponentType();
            return componentType.accept(this).createArrayType();
        }

        @Override
        @Nullable
        public PsiType visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return lambdaExpressionType;
        }

        @Override
        public PsiType visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
            return methodReferenceType;
        }

        @Override
        public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
            return PsiIntersectionType.createIntersection((PsiType[])Arrays.stream(intersectionType.getConjuncts()).map(conjunct -> conjunct.accept(this)).toArray(PsiType[]::new));
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult result = classType.resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiManager manager = aClass.getManager();
                PsiSubstitutor targetSubstitutor = PsiSubstitutor.EMPTY;
                PsiSubstitutor substitutor = result.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType ai = substitutor.substitute(parameter);
                    targetSubstitutor = targetSubstitutor.put(parameter, ai);
                    if (ai == null || !JavaVarTypeUtil.mentionsRestrictedTypeVariables(ai)) continue;
                    if (ai instanceof PsiWildcardType) {
                        if (((PsiWildcardType)ai).isExtends()) {
                            targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createExtends(manager, ((PsiWildcardType)ai).getExtendsBound().accept(this)));
                        }
                        if (!((PsiWildcardType)ai).isSuper()) continue;
                        targetSubstitutor = targetSubstitutor.put(parameter, UpwardProjectionTypeVisitor.createDownwardProjection(manager, ((PsiWildcardType)ai).getSuperBound()));
                        continue;
                    }
                    PsiType U = ai.accept(this);
                    if (!U.equalsToText("java.lang.Object") && UpwardProjectionTypeVisitor.tryUpperBound(aClass, parameter, U)) {
                        targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createExtends(manager, U));
                        continue;
                    }
                    targetSubstitutor = targetSubstitutor.put(parameter, UpwardProjectionTypeVisitor.createDownwardProjection(manager, ai));
                }
                return JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory().createType(aClass, targetSubstitutor);
            }
            return classType;
        }

        private static PsiWildcardType createDownwardProjection(PsiManager manager, PsiType bound) {
            PsiType downwardProjection = JavaVarTypeUtil.getDownwardProjection(bound);
            return downwardProjection != PsiType.NULL ? PsiWildcardType.createSuper(manager, downwardProjection) : PsiWildcardType.createUnbounded(manager);
        }

        private static boolean tryUpperBound(PsiClass aClass, PsiTypeParameter parameter, PsiType U) {
            PsiType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length == 0) {
                return true;
            }
            PsiType bi = PsiIntersectionType.createIntersection(extendsListTypes);
            return PsiPolyExpressionUtil.mentionsTypeParameters(bi, ContainerUtil.newHashSet(aClass.getTypeParameters())) != false || !U.isAssignableFrom(bi);
        }
    }
}

