/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

abstract class KeyedMethodVisitor
extends ClassVisitor {
    private static final int STABLE_FLAGS = 26;
    String className;
    private boolean stableClass;

    KeyedMethodVisitor() {
        super(393216);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.stableClass = (access & 0x10) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodNode node = new MethodNode(393216, access, name, desc, signature, exceptions);
        Method method = new Method(this.className, node.name, node.desc);
        boolean stable = this.stableClass || (node.access & 0x1A) != 0 || "<init>".equals(node.name);
        return this.visitMethod(node, method, new EKey(method, Direction.Out, stable));
    }

    @Nullable
    abstract MethodVisitor visitMethod(MethodNode var1, Method var2, EKey var3);
}

