/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalUsedAsFieldOrParameterTypeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("optional.used.as.field.or.parameter.type.display.name", new Object[0]);
        if (string == null) {
            OptionalUsedAsFieldOrParameterTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiTypeElement typeElement = (PsiTypeElement)infos[0];
        PsiElement parent = typeElement.getParent();
        if (parent instanceof PsiField) {
            PsiField field = (PsiField)parent;
            String string = InspectionGadgetsBundle.message("optional.used.as.field.type.problem.descriptor", field.getName());
            if (string == null) {
                OptionalUsedAsFieldOrParameterTypeInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (parent instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)parent;
            String string = InspectionGadgetsBundle.message("optional.used.as.parameter.type.problem.descriptor", parameter.getName());
            if (string == null) {
                OptionalUsedAsFieldOrParameterTypeInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        throw new AssertionError();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionUsedAsFieldOrParameterTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/OptionalUsedAsFieldOrParameterTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OptionUsedAsFieldOrParameterTypeVisitor
    extends BaseInspectionVisitor {
        private OptionUsedAsFieldOrParameterTypeVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            this.checkTypeElement(field.getTypeElement());
        }

        @Override
        public void visitParameter(PsiParameter parameter) {
            super.visitParameter(parameter);
            PsiElement scope = parameter.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)scope;
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            this.checkTypeElement(parameter.getTypeElement());
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            if (typeElement == null || !TypeUtils.isOptional(typeElement.getType())) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement);
        }
    }
}

