/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class IteratorNextDoesNotThrowNoSuchElementExceptionInspection
extends BaseInspection {
    static final MethodMatcher methodMatcher = new MethodMatcher().add("java.util.Scanner", "next").add("java.util.StringTokenizer", "next(Element|Token)").add("java.util.Iterator", "next").add("java.util.ListIterator", "previous").add("java.util.Enumeration", "nextElement").add("java.util.PrimitiveIterator.OfInt", "nextInt").add("java.util.PrimitiveIterator.OfLong", "nextLong").add("java.util.PrimitiveIterator.OfDouble", "nextDouble");

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("IteratorNextCanNotThrowNoSuchElementException" == null) {
            IteratorNextDoesNotThrowNoSuchElementExceptionInspection.$$$reportNull$$$0(0);
        }
        return "IteratorNextCanNotThrowNoSuchElementException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.display.name", new Object[0]);
        if (string == null) {
            IteratorNextDoesNotThrowNoSuchElementExceptionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.problem.descriptor", new Object[0]);
        if (string == null) {
            IteratorNextDoesNotThrowNoSuchElementExceptionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IteratorNextDoesNotThrowNoSuchElementExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CalledMethodsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean noSuchElementExceptionThrown;

        private CalledMethodsVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.noSuchElementExceptionThrown) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null || methodMatcher.matches(method)) {
                this.noSuchElementExceptionThrown = true;
                return;
            }
            if (method instanceof PsiCompiledElement) {
                return;
            }
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(method);
            for (PsiType psiType : exceptions) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                this.noSuchElementExceptionThrown = true;
            }
        }

        boolean isNoSuchElementExceptionThrown() {
            return this.noSuchElementExceptionThrown;
        }
    }

    private static class IteratorNextDoesNotThrowNoSuchElementExceptionVisitor
    extends BaseInspectionVisitor {
        private IteratorNextDoesNotThrowNoSuchElementExceptionVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                IteratorNextDoesNotThrowNoSuchElementExceptionVisitor.$$$reportNull$$$0(0);
            }
            if (!MethodUtils.methodMatches(method, "java.util.Iterator", null, "next", new PsiType[0])) {
                return;
            }
            for (PsiType psiType : ExceptionUtil.getThrownExceptions(method)) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                return;
            }
            CalledMethodsVisitor visitor = new CalledMethodsVisitor();
            method.accept(visitor);
            if (visitor.isNoSuchElementExceptionThrown()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection$IteratorNextDoesNotThrowNoSuchElementExceptionVisitor", "visitMethod"));
        }
    }
}

