/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleCheckedLockingInspection
extends BaseInspection {
    public boolean ignoreOnVolatileVariables = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.checked.locking.display.name", new Object[0]);
        if (string == null) {
            DoubleCheckedLockingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.checked.locking.problem.descriptor", new Object[0]);
        if (string == null) {
            DoubleCheckedLockingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("double.checked.locking.ignore.on.volatiles.option", new Object[0]), this, "ignoreOnVolatileVariables");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        if (field == null) {
            return null;
        }
        return new DoubleCheckedLockingFix(field);
    }

    @Nullable
    private static PsiField findCheckedField(PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            return (PsiField)target;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!ComparisonUtils.isComparisonOperation(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiField field = DoubleCheckedLockingInspection.findCheckedField(lhs);
            if (field != null) {
                return field;
            }
            return DoubleCheckedLockingInspection.findCheckedField(rhs);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                return null;
            }
            return DoubleCheckedLockingInspection.findCheckedField(prefixExpression.getOperand());
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleCheckedLockingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/DoubleCheckedLockingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class DoubleCheckedLockingVisitor
    extends BaseInspectionVisitor {
        private DoubleCheckedLockingVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiField field;
            if (statement == null) {
                DoubleCheckedLockingVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            PsiExpression outerCondition = statement.getCondition();
            if (outerCondition == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(outerCondition)) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)thenBranch;
            PsiCodeBlock body = synchronizedStatement.getBody();
            PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(body);
            if (!(firstStatement instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement innerIf = (PsiIfStatement)firstStatement;
            PsiExpression innerCondition = innerIf.getCondition();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(innerCondition, outerCondition)) {
                return;
            }
            if (DoubleCheckedLockingInspection.this.ignoreOnVolatileVariables) {
                field = DoubleCheckedLockingInspection.findCheckedField(innerCondition);
                if (field != null && field.hasModifierProperty("volatile")) {
                    return;
                }
            } else {
                field = null;
            }
            this.registerStatementError(statement, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/DoubleCheckedLockingInspection$DoubleCheckedLockingVisitor", "visitIfStatement"));
        }
    }

    private static class DoubleCheckedLockingFix
    extends InspectionGadgetsFix {
        private final String myFieldName;

        private DoubleCheckedLockingFix(PsiField field) {
            this.myFieldName = field.getName();
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("double.checked.locking.quickfix", this.myFieldName);
            if (string == null) {
                DoubleCheckedLockingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make field volatile" == null) {
                DoubleCheckedLockingFix.$$$reportNull$$$0(1);
            }
            return "Make field volatile";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiField field = DoubleCheckedLockingInspection.findCheckedField(condition);
            if (field == null) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty("volatile", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/threading/DoubleCheckedLockingInspection$DoubleCheckedLockingFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

