/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private SoftReference<PsiAnnotationMemberValue> myCachedDefaultValue;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            PsiAnnotationMethodImpl.$$$reportNull$$$0(0);
        }
        return "abstract".equals(name) || "public".equals(name) || super.hasModifierProperty(name);
    }

    @Override
    protected void dropCached() {
        this.myCachedDefaultValue = null;
    }

    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String text = stub.getDefaultValueText();
            if (StringUtil.isEmpty(text)) {
                return null;
            }
            PsiAnnotationMemberValue value = SoftReference.dereference(this.myCachedDefaultValue);
            if (value != null) {
                return value;
            }
            value = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@Foo(" + text + ")", this).findAttributeValue(null);
            this.myCachedDefaultValue = new SoftReference<PsiAnnotationMemberValue>(value);
            return value;
        }
        this.myCachedDefaultValue = null;
        ASTNode node = this.getNode().findChildByRole(248);
        if (node == null) {
            return null;
        }
        return (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiAnnotationMethodImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationMethod(this);
        } else {
            visitor.visitElement(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/PsiAnnotationMethodImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasModifierProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

