/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateHighlightersUtil {
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NODUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare(o1.getSeverity(), o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal(o1.type, o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal(o1.getGutterIconRenderer(), o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributes, o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributesKey, o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare(o1.getDescription(), o2.getDescription());
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create("TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(HighlightInfo info, HighlightInfo coveredBy) {
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull Project project, @NotNull Document document, @NotNull PsiFile file, int startOffset, int endOffset, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull Map<TextRange, RangeMarker> ranges2markersCache) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(0);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(2);
        }
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(3);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info)) {
            return;
        }
        if (info.getStartOffset() < startOffset || info.getEndOffset() > endOffset) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info, severityRegistrar);
        Processor<HighlightInfo> otherHighlightInTheWayProcessor = oldInfo -> {
            if (info == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(69);
            }
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group || !oldInfo.equalsByActualOffset(info);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project, null, info.getActualStartOffset(), info.getActualEndOffset(), otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, file, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        }
    }

    public static boolean isFileLevelOrGutterAnnotation(HighlightInfo info) {
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(5);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(6);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(7);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        codeAnalyzer.cleanFileLevelHighlights(project, group, psiFile);
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        UpdateHighlightersUtil.setHighlightersInRange(project, document, range, colorsScheme, new ArrayList<HighlightInfo>(highlights), (MarkupModelEx)markup, group);
    }

    @Deprecated
    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<HighlightInfo> highlights, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(8);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(9);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(10);
        }
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, null, group);
    }

    static void setHighlightersOutsideRange(@NotNull Project project, @NotNull Document document, @NotNull PsiFile psiFile, @NotNull List<HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(11);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(12);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(13);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(14);
        }
        if (priorityRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(project, group, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(infos, BY_START_OFFSET_NODUPS);
        THashSet infoSet = new THashSet(infos);
        Processor<HighlightInfo> processor = arg_0 -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$2(group, document, startOffset, endOffset, (Set)infoSet, priorityRange, infosToRemove, arg_0);
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project, null, priorityRange.getStartOffset(), priorityRange.getEndOffset(), processor);
        THashMap ranges2markersCache = new THashMap(10);
        boolean[] changed = new boolean[]{false};
        SweepProcessor.Generator generator = proc -> {
            if (infos == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(66);
            }
            return ContainerUtil.process(infos, proc);
        };
        SweepProcessor.sweep(generator, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$4(document, startOffset, endOffset, codeAnalyzer, project, group, psiFile, changed, severityRegistrar, priorityRange, colorsScheme, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed[0] = true;
        }
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    static void setHighlightersInRange(@NotNull Project project, @NotNull Document document, @NotNull TextRange range, @Nullable EditorColorsScheme colorsScheme, @NotNull List<HighlightInfo> infos, @NotNull MarkupModelEx markup, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(16);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(17);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(18);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(19);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, range.getStartOffset(), range.getEndOffset(), info -> {
            if (document == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(60);
            }
            if (range == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(61);
            }
            if (info.getGroup() == group) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range.getEndOffset() == document.getTextLength() || range.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter(highlighter);
                    info.setHighlighter(null);
                }
            }
            return true;
        });
        ContainerUtil.quickSort(infos, BY_START_OFFSET_NODUPS);
        THashMap ranges2markersCache = new THashMap(10);
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        boolean[] changed = new boolean[]{false};
        SweepProcessor.Generator generator = processor -> {
            if (infos == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(59);
            }
            return ContainerUtil.process(infos, processor);
        };
        SweepProcessor.sweep(generator, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersInRange$7(psiFile, codeAnalyzer, project, group, changed, severityRegistrar, range, colorsScheme, document, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed[0] = true;
        }
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull Collection<HighlightInfo> overlappingIntervals, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(21);
        }
        if (overlappingIntervals == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(22);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(23);
        }
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo overlapping : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, overlapping)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (warning == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(24);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(25);
        }
        if (candidate == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(26);
        }
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        HighlightSeverity severity = candidate.getSeverity();
        if (severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(27);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(28);
        }
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity = info.getSeverity()) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(29);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(30);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(31);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(32);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(33);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(34);
        }
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        RangeHighlighterEx highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer);
        TextRange finalInfoRange = new TextRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info.getTextAttributes(psiFile, colorsScheme);
        Consumer<RangeHighlighterEx> changeAttributes = finalHighlighter -> {
            ProperTextRange fixRange;
            if (info == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(51);
            }
            if (psiFile == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(52);
            }
            if (ranges2markersCache == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(53);
            }
            if (document == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(54);
            }
            if (infoAttributes != null) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            info.setHighlighter((RangeHighlighterEx)finalHighlighter);
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color color = info.getErrorStripeMarkColor(psiFile, colorsScheme);
            finalHighlighter.setErrorStripeMarkColor(color);
            if (info != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip(info);
            }
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, info.getHighlighter());
            if (info.quickFixActionRanges != null) {
                ArrayList list = new ArrayList(info.quickFixActionRanges.size());
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange textRange = (TextRange)pair.second;
                    RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, textRange);
                    list.add(Pair.create(pair.first, marker));
                }
                info.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list);
            }
            info.fixMarker = finalInfoRange.equals(fixRange = info.getFixTextRange()) ? null : UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, fixRange);
        };
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(infoStartOffset, infoEndOffset, layer, null, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
            if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info.type)) {
                highlighter.setVisibleIfFolded(true);
            }
        } else {
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        boolean attributesSet = Comparing.equal(infoAttributes, highlighter.getTextAttributes());
        assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes();
    }

    private static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(35);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(36);
        }
        int layer = (severity = info.getSeverity()) == HighlightSeverity.WARNING ? 4000 : (severity == HighlightSeverity.WEAK_WARNING ? 3750 : (severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY ? 1999 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : 3000))));
        return layer;
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull TextRange textRange) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(37);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(38);
        }
        if (textRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(39);
        }
        RangeMarker rangeMarker = ranges2markersCache.computeIfAbsent(textRange, __ -> {
            if (document == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(49);
            }
            if (textRange == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(50);
            }
            return document.createRangeMarker(textRange);
        });
        if (rangeMarker == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(40);
        }
        return rangeMarker;
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(41);
        }
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(42);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(43);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project, @NotNull DocumentEvent e) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(44);
        }
        if (e == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(45);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        int start = e.getOffset() - 1;
        int end = start + e.getOldLength();
        ArrayList toRemove = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, start, end, info -> {
            if (!info.needUpdateOnTyping()) {
                return true;
            }
            RangeHighlighterEx highlighter = info.getHighlighter();
            int highlighterStart = highlighter.getStartOffset();
            int highlighterEnd = highlighter.getEndOffset();
            if (info.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start < highlighterEnd && highlighterStart <= end) {
                toRemove.add(info);
            }
            return true;
        });
        for (HighlightInfo info2 : toRemove) {
            if (info2.getHighlighter().isValid() && !info2.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info2.getHighlighter().dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        if (!toRemove.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project) {
        RangeHighlighter[] allHighlighters;
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(46);
        }
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(47);
        }
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), info -> {
            if (markup == null) {
                UpdateHighlightersUtil.$$$reportNull$$$0(48);
            }
            assert (((MarkupModelEx)markup).containsHighlighter(info.getHighlighter()));
            return true;
        });
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            Object tooltip;
            if (!highlighter.isValid() || !((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo)) continue;
            HighlightInfo info2 = (HighlightInfo)tooltip;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights(document, project, null, info2.getActualStartOffset(), info2.getActualEndOffset(), highlightInfo -> BY_START_OFFSET_NODUPS.compare((HighlightInfo)highlightInfo, info2) != 0);
            assert (contains) : info2;
        }
    }

    private static /* synthetic */ boolean lambda$setHighlightersInRange$7(PsiFile psiFile, DaemonCodeAnalyzerEx codeAnalyzer, @NotNull Project project, int group, boolean[] changed, SeverityRegistrar severityRegistrar, @NotNull TextRange range, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, @NotNull MarkupModelEx markup, HighlightersRecycler infosToRemove, Map ranges2markersCache, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(55);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(56);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(57);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(58);
        }
        if (!atStart) {
            return true;
        }
        if (info.isFileLevelAnnotation() && psiFile != null && psiFile.getViewProvider().isPhysical()) {
            codeAnalyzer.addFileLevelHighlight(project, group, info, psiFile);
            changed[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() >= range.getStartOffset() && info.getEndOffset() <= range.getEndOffset() && psiFile != null) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, markup, infosToRemove, ranges2markersCache, severityRegistrar);
            changed[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$4(@NotNull Document document, int startOffset, int endOffset, DaemonCodeAnalyzerEx codeAnalyzer, @NotNull Project project, int group, @NotNull PsiFile psiFile, boolean[] changed, SeverityRegistrar severityRegistrar, @NotNull ProperTextRange priorityRange, @Nullable EditorColorsScheme colorsScheme, MarkupModel markup, HighlightersRecycler infosToRemove, Map ranges2markersCache, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(62);
        }
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(63);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(64);
        }
        if (priorityRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(65);
        }
        if (!atStart) {
            return true;
        }
        if (!(info.isFromInjection() || info.getEndOffset() >= document.getTextLength() || info.getEndOffset() > startOffset && info.getStartOffset() < endOffset)) {
            return true;
        }
        if (info.isFileLevelAnnotation()) {
            codeAnalyzer.addFileLevelHighlight(project, group, info, psiFile);
            changed[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() < priorityRange.getStartOffset() || info.getEndOffset() > priorityRange.getEndOffset()) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, (MarkupModelEx)markup, infosToRemove, ranges2markersCache, severityRegistrar);
            changed[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$2(int group, @NotNull Document document, int startOffset, int endOffset, Set infoSet, @NotNull ProperTextRange priorityRange, HighlightersRecycler infosToRemove, HighlightInfo info) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(67);
        }
        if (priorityRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(68);
        }
        if (info.getGroup() == group) {
            boolean toRemove;
            RangeHighlighterEx highlighter = info.getHighlighter();
            int hiStart = highlighter.getStartOffset();
            int hiEnd = highlighter.getEndOffset();
            if (!(info.isFromInjection() || hiEnd >= document.getTextLength() || hiEnd > startOffset && hiStart < endOffset)) {
                return true;
            }
            boolean bl = toRemove = infoSet.contains(info) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
            if (toRemove) {
                infosToRemove.recycleHighlighter(highlighter);
                info.setHighlighter(null);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 30: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 49: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 21: 
            case 27: 
            case 29: 
            case 35: 
            case 51: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 33: 
            case 38: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2markersCache";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 13: 
            case 31: 
            case 52: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: 
            case 19: 
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 15: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 18: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 20: 
            case 32: 
            case 46: 
            case 48: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlappingIntervals";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 39: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighterToEditorIncrementally";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersToEditor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersOutsideRange";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersInRange";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isWarningCoveredByError";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCovered";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSevere";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createOrReuseHighlighterFor";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLayer";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceOptimizationAllowed";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "disableWhiteSpaceOptimization";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "clearWhiteSpaceOptimizationFlag";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlightersByTyping";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "assertMarkupConsistent";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$assertMarkupConsistent$11";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreate$9";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOrReuseHighlighterFor$8";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHighlightersInRange$7";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHighlightersInRange$6";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHighlightersInRange$5";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHighlightersOutsideRange$4";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHighlightersOutsideRange$3";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setHighlightersOutsideRange$2";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addHighlighterToEditorIncrementally$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

