/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingColors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class XmlTagTreeHighlightingUtil {
    private XmlTagTreeHighlightingUtil() {
    }

    static boolean containsTagsWithSameName(PsiElement[] elements) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            String name;
            if (!(element instanceof XmlTag) || names.add(name = ((XmlTag)element).getName())) continue;
            return true;
        }
        return false;
    }

    static boolean isTagTreeHighlightingActive(PsiFile file) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!XmlTagTreeHighlightingUtil.hasXmlViewProvider(file)) {
            return false;
        }
        return WebEditorOptions.getInstance().isTagTreeHighlightingEnabled();
    }

    private static boolean hasXmlViewProvider(@NotNull PsiFile file) {
        if (file == null) {
            XmlTagTreeHighlightingUtil.$$$reportNull$$$0(0);
        }
        for (PsiFile f : file.getViewProvider().getAllFiles()) {
            if (!(f instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    public static Color makeTransparent(@NotNull Color color, @NotNull Color backgroundColor, double transparency) {
        if (color == null) {
            XmlTagTreeHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (backgroundColor == null) {
            XmlTagTreeHighlightingUtil.$$$reportNull$$$0(2);
        }
        int r = XmlTagTreeHighlightingUtil.makeTransparent(transparency, color.getRed(), backgroundColor.getRed());
        int g = XmlTagTreeHighlightingUtil.makeTransparent(transparency, color.getGreen(), backgroundColor.getGreen());
        int b = XmlTagTreeHighlightingUtil.makeTransparent(transparency, color.getBlue(), backgroundColor.getBlue());
        return new Color(r, g, b);
    }

    private static int makeTransparent(double transparency, int channel, int backgroundChannel) {
        int result2 = (int)((double)backgroundChannel * (1.0 - transparency) + (double)channel * transparency);
        if (result2 < 0) {
            return 0;
        }
        if (result2 > 255) {
            return 255;
        }
        return result2;
    }

    static Color[] getBaseColors() {
        ColorKey[] colorKeys = XmlTagTreeHighlightingColors.getColorKeys();
        Color[] colors = new Color[colorKeys.length];
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorsScheme.getColor(colorKeys[i]);
        }
        return colors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasXmlViewProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "makeTransparent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

