/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.util.SingletonSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

final class CombinedAnalysis {
    private final ControlFlowGraph controlFlow;
    private final Member method;
    private final CombinedInterpreter interpreter;
    private BasicValue returnValue;
    private boolean exception;
    private final MethodNode methodNode;

    CombinedAnalysis(Member method, ControlFlowGraph controlFlow) {
        this.method = method;
        this.controlFlow = controlFlow;
        this.methodNode = controlFlow.methodNode;
        this.interpreter = new CombinedInterpreter(this.methodNode.instructions, Type.getArgumentTypes((String)this.methodNode.desc).length);
    }

    final void analyze() throws AnalyzerException {
        Frame<BasicValue> frame = this.createStartFrame();
        int insnIndex = 0;
        block8: while (true) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    insnIndex = this.controlFlow.transitions[insnIndex][0];
                    continue block8;
                }
            }
            switch (insnNode.getOpcode()) {
                case 191: {
                    this.exception = true;
                    return;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.returnValue = (BasicValue)frame.pop();
                    return;
                }
                case 177: {
                    return;
                }
            }
            frame.execute(insnNode, (Interpreter)this.interpreter);
            insnIndex = this.controlFlow.transitions[insnIndex][0];
        }
    }

    final Equation notNullParamEquation(int i, boolean stable) {
        Result result2;
        EKey key = new EKey(this.method, new Direction.In(i, false), stable);
        if (this.interpreter.dereferencedParams[i]) {
            result2 = new Final(Value.NotNull);
        } else {
            Set<CombinedData.ParamKey> calls = this.interpreter.parameterFlow[i];
            if (calls == null || calls.isEmpty()) {
                result2 = new Final(Value.Top);
            } else {
                HashSet<EKey> keys = new HashSet<EKey>();
                for (CombinedData.ParamKey pk : calls) {
                    keys.add(new EKey(pk.method, new Direction.In(pk.i, false), pk.stable));
                }
                result2 = new Pending(new SingletonSet<Component>(new Component(Value.Top, keys)));
            }
        }
        return new Equation(key, result2);
    }

    final Equation nullableParamEquation(int i, boolean stable) {
        Result result2;
        EKey key = new EKey(this.method, new Direction.In(i, true), stable);
        if (this.interpreter.dereferencedParams[i] || this.interpreter.notNullableParams[i] || this.returnValue instanceof AbstractValues.NthParamValue && ((AbstractValues.NthParamValue)this.returnValue).n == i) {
            result2 = new Final(Value.Top);
        } else {
            Set<CombinedData.ParamKey> calls = this.interpreter.parameterFlow[i];
            if (calls == null || calls.isEmpty()) {
                result2 = new Final(Value.Null);
            } else {
                HashSet<Component> sum = new HashSet<Component>();
                for (CombinedData.ParamKey pk : calls) {
                    sum.add(new Component(Value.Top, Collections.singleton(new EKey(pk.method, new Direction.In(pk.i, true), pk.stable))));
                }
                result2 = new Pending(sum);
            }
        }
        return new Equation(key, result2);
    }

    @Nullable
    final Equation contractEquation(int i, Value inValue, boolean stable) {
        Result result2;
        Direction.InOut direction = new Direction.InOut(i, inValue);
        EKey key = new EKey(this.method, direction, stable);
        if (this.exception || inValue == Value.Null && this.interpreter.dereferencedParams[i]) {
            result2 = new Final(Value.Bot);
        } else if (AbstractValues.FalseValue == this.returnValue) {
            result2 = new Final(Value.False);
        } else if (AbstractValues.TrueValue == this.returnValue) {
            result2 = new Final(Value.True);
        } else if (this.returnValue instanceof CombinedData.TrackableNullValue) {
            result2 = new Final(Value.Null);
        } else if (this.returnValue instanceof AbstractValues.NotNullValue || CombinedData.ThisValue == this.returnValue) {
            result2 = new Final(Value.NotNull);
        } else if (this.returnValue instanceof AbstractValues.NthParamValue && ((AbstractValues.NthParamValue)this.returnValue).n == i) {
            result2 = new Final(inValue);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            Set<EKey> keys = call.getKeysForParameter(i, direction);
            if (ASMUtils.isReferenceType(call.getType())) {
                keys.add(new EKey(call.method, Direction.Out, call.stableCall));
            }
            if (keys.isEmpty()) {
                return null;
            }
            result2 = new Pending(new SingletonSet<Component>(new Component(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result2);
    }

    @Nullable
    final Equation failEquation(boolean stable) {
        Result result2;
        EKey key = new EKey(this.method, Direction.Throw, stable);
        if (this.exception) {
            result2 = new Final(Value.Fail);
        } else if (!this.interpreter.calls.isEmpty()) {
            Set<EKey> keys = this.interpreter.calls.stream().map(call -> new EKey(call.method, Direction.Throw, call.stableCall)).collect(Collectors.toSet());
            result2 = new Pending(new SingletonSet<Component>(new Component(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result2);
    }

    @Nullable
    final Equation failEquation(int i, Value inValue, boolean stable) {
        Result result2;
        Direction.InThrow direction = new Direction.InThrow(i, inValue);
        EKey key = new EKey(this.method, direction, stable);
        if (this.exception) {
            result2 = new Final(Value.Fail);
        } else if (!this.interpreter.calls.isEmpty()) {
            HashSet<EKey> keys = new HashSet<EKey>();
            for (CombinedData.TrackableCallValue call : this.interpreter.calls) {
                keys.addAll(call.getKeysForParameter(i, direction));
                keys.add(new EKey(call.method, Direction.Throw, call.stableCall));
            }
            result2 = new Pending(new SingletonSet<Component>(new Component(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result2);
    }

    @Nullable
    final Equation outContractEquation(boolean stable) {
        Result result2;
        EKey key = new EKey(this.method, Direction.Out, stable);
        if (this.exception) {
            result2 = new Final(Value.Bot);
        } else if (AbstractValues.FalseValue == this.returnValue) {
            result2 = new Final(Value.False);
        } else if (AbstractValues.TrueValue == this.returnValue) {
            result2 = new Final(Value.True);
        } else if (this.returnValue instanceof CombinedData.TrackableNullValue) {
            result2 = new Final(Value.Null);
        } else if (this.returnValue instanceof AbstractValues.NotNullValue || this.returnValue == CombinedData.ThisValue) {
            result2 = new Final(Value.NotNull);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            EKey callKey = new EKey(call.method, Direction.Out, call.stableCall);
            SingletonSet<EKey> keys = new SingletonSet<EKey>(callKey);
            result2 = new Pending(new SingletonSet<Component>(new Component(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result2);
    }

    final Equation nullableResultEquation(boolean stable) {
        Result result2;
        EKey key = new EKey(this.method, Direction.NullableOut, stable);
        if (this.exception || this.returnValue instanceof CombinedData.Trackable && this.interpreter.dereferencedValues[((CombinedData.Trackable)this.returnValue).getOriginInsnIndex()]) {
            result2 = new Final(Value.Bot);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            EKey callKey = new EKey(call.method, Direction.NullableOut, call.stableCall || call.thisCall);
            SingletonSet<EKey> keys = new SingletonSet<EKey>(callKey);
            result2 = new Pending(new SingletonSet<Component>(new Component(Value.Null, keys)));
        } else {
            result2 = this.returnValue instanceof CombinedData.TrackableNullValue ? new Final(Value.Null) : new Final(Value.Bot);
        }
        return new Equation(key, result2);
    }

    final Frame<BasicValue> createStartFrame() {
        Frame frame = new Frame(this.methodNode.maxLocals, this.methodNode.maxStack);
        Type returnType = Type.getReturnType((String)this.methodNode.desc);
        BasicValue returnValue = Type.VOID_TYPE.equals((Object)returnType) ? null : new BasicValue(returnType);
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)returnValue);
        Type[] args = Type.getArgumentTypes((String)this.methodNode.desc);
        int local = 0;
        if ((this.methodNode.access & 8) == 0) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)CombinedData.ThisValue);
        }
        for (int i = 0; i < args.length; ++i) {
            AbstractValues.NthParamValue value = new AbstractValues.NthParamValue(args[i], i);
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value);
            if (args[i].getSize() != 2) continue;
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        while (local < this.methodNode.maxLocals) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        return frame;
    }
}

