/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.NullityInferenceResult;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInference {
    public static Nullness inferNullity(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullness.UNKNOWN;
        }
        PsiType type = method.getReturnType();
        if (type == null || type instanceof PsiPrimitiveType) {
            return Nullness.UNKNOWN;
        }
        return (Nullness)((Object)CachedValuesManager.getCachedValue(method, () -> {
            Nullness nullness;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            NullityInferenceResult result2 = data == null ? null : data.getNullity();
            Nullness nullness2 = nullness = result2 == null ? null : RecursionManager.doPreventingRecursion(method, true, () -> result2.getNullness(method, data.methodBody(method)));
            if (nullness == null) {
                nullness = Nullness.UNKNOWN;
            }
            return CachedValueProvider.Result.create(nullness, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }));
    }

    public static Nullness inferNullity(PsiParameter parameter) {
        if (!parameter.isPhysical() || parameter.getType() instanceof PsiPrimitiveType) {
            return Nullness.UNKNOWN;
        }
        PsiParameterList parent = ObjectUtils.tryCast(parameter.getParent(), PsiParameterList.class);
        if (parent == null) {
            return Nullness.UNKNOWN;
        }
        PsiMethodImpl method = ObjectUtils.tryCast(parent.getParent(), PsiMethodImpl.class);
        if (method == null || !InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullness.UNKNOWN;
        }
        return (Nullness)((Object)CachedValuesManager.getCachedValue(parameter, () -> {
            int index;
            BitSet notNullParameters;
            Nullness nullness = Nullness.UNKNOWN;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            if (data != null && !(notNullParameters = data.getNotNullParameters()).isEmpty() && notNullParameters.get(index = ArrayUtil.indexOf(parent.getParameters(), parameter))) {
                nullness = Nullness.NOT_NULL;
            }
            return CachedValueProvider.Result.create(nullness, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }));
    }

    static class NullityInferenceVisitor {
        private final LighterAST tree;
        private final LighterASTNode body;
        private boolean hasErrors;
        private boolean hasNotNulls;
        private boolean hasNulls;
        private boolean hasUnknowns;
        MultiMap<String, ExpressionRange> delegates = MultiMap.create();
        Set<String> assignments = ContainerUtil.newHashSet();
        Set<String> returnedCheckedVars = ContainerUtil.newHashSet();

        NullityInferenceVisitor(LighterAST tree, LighterASTNode body) {
            this.tree = tree;
            this.body = body;
        }

        void visitNode(LighterASTNode element) {
            IElementType type = element.getTokenType();
            if (type == TokenType.ERROR_ELEMENT) {
                this.hasErrors = true;
            } else if (type == JavaElementType.RETURN_STATEMENT) {
                LighterASTNode value = JavaLightTreeUtil.findExpressionChild(this.tree, element);
                if (value == null) {
                    this.hasErrors = true;
                } else {
                    this.visitReturnedValue(value);
                }
            } else if (type == JavaElementType.ASSIGNMENT_EXPRESSION) {
                ContainerUtil.addIfNotNull(this.assignments, JavaLightTreeUtil.getNameIdentifierText(this.tree, JavaLightTreeUtil.findExpressionChild(this.tree, element)));
            }
        }

        private void visitReturnedValue(@Nullable LighterASTNode expr) {
            if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, expr)) == null) {
                this.hasErrors = true;
                return;
            }
            IElementType type = expr.getTokenType();
            if (this.isNullLiteral(expr)) {
                this.hasNulls = true;
            } else if (type == JavaElementType.LAMBDA_EXPRESSION || type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.METHOD_REF_EXPRESSION || type == JavaElementType.LITERAL_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION || type == JavaElementType.POLYADIC_EXPRESSION) {
                this.hasNotNulls = true;
            } else if (type == JavaElementType.METHOD_CALL_EXPRESSION) {
                String calledMethod = JavaLightTreeUtil.getNameIdentifierText(this.tree, this.tree.getChildren(expr).get(0));
                if (calledMethod != null) {
                    this.delegates.putValue(calledMethod, ExpressionRange.create(expr, this.body.getStartOffset()));
                }
            } else if (type == JavaElementType.CONDITIONAL_EXPRESSION) {
                List<LighterASTNode> expressionChildren = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
                if (expressionChildren.size() == 3) {
                    this.visitReturnedValue(expressionChildren.get(1));
                    this.visitReturnedValue(expressionChildren.get(2));
                } else {
                    this.hasUnknowns = true;
                }
            } else if (type == JavaElementType.REFERENCE_EXPRESSION) {
                LighterASTNode target = new FileLocalResolver(this.tree).resolveLocally(expr).getTarget();
                if (target != null && (target.getTokenType() == JavaElementType.LOCAL_VARIABLE || target.getTokenType() == JavaElementType.PARAMETER) && this.isCheckedForNotNull(target, expr)) {
                    ContainerUtil.addIfNotNull(this.returnedCheckedVars, JavaLightTreeUtil.getNameIdentifierText(this.tree, target));
                } else {
                    this.hasUnknowns = true;
                }
            } else {
                this.hasUnknowns = true;
            }
        }

        private boolean isCheckedForNotNull(LighterASTNode var, LighterASTNode ref) {
            JBIterable<LighterASTNode> hierarchy = JBIterable.generate(ref, this.tree::getParent);
            for (Pair<LighterASTNode, LighterASTNode> pair : ContainerUtil.zip(hierarchy, hierarchy.skip(1))) {
                List<LighterASTNode> operands;
                LighterASTNode eachParent = (LighterASTNode)pair.second;
                LighterASTNode prevParent = (LighterASTNode)pair.first;
                IElementType type = eachParent.getTokenType();
                if (type == JavaElementType.IF_STATEMENT && prevParent.equals(ContainerUtil.getFirstItem(ContractInferenceInterpreter.getStatements(eachParent, this.tree))) && this.isNonNullCondition(JavaLightTreeUtil.findExpressionChild(this.tree, eachParent), var)) {
                    return true;
                }
                if (type != JavaElementType.CONDITIONAL_EXPRESSION || (operands = JavaLightTreeUtil.getExpressionChildren(this.tree, eachParent)).size() != 3 || !prevParent.equals(operands.get(1)) || !this.isNonNullCondition(operands.get(0), var)) continue;
                return true;
            }
            return false;
        }

        private boolean isNonNullCondition(@Nullable LighterASTNode expr, LighterASTNode var) {
            if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, expr)) == null) {
                return false;
            }
            IElementType type = expr.getTokenType();
            if (type == JavaElementType.BINARY_EXPRESSION || type == JavaElementType.POLYADIC_EXPRESSION) {
                List<LighterASTNode> operands = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
                if (LightTreeUtil.firstChildOfType(this.tree, expr, JavaTokenType.NE) != null) {
                    return operands.size() == 2 && this.isNullLiteral(operands.get(1)) && this.isReferenceTo(operands.get(0), var);
                }
                return LightTreeUtil.firstChildOfType(this.tree, expr, JavaTokenType.ANDAND) != null && ContainerUtil.exists(operands, e -> this.isNonNullCondition((LighterASTNode)e, var));
            }
            return type == JavaElementType.INSTANCE_OF_EXPRESSION && this.isReferenceTo(expr, var);
        }

        private boolean isReferenceTo(@NotNull LighterASTNode expr, @NotNull LighterASTNode var) {
            LighterASTNode operand;
            if (expr == null) {
                NullityInferenceVisitor.$$$reportNull$$$0(0);
            }
            if (var == null) {
                NullityInferenceVisitor.$$$reportNull$$$0(1);
            }
            if ((operand = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, JavaLightTreeUtil.findExpressionChild(this.tree, expr))) == null || operand.getTokenType() != JavaElementType.REFERENCE_EXPRESSION || !Objects.equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, operand), JavaLightTreeUtil.getNameIdentifierText(this.tree, operand))) {
                return false;
            }
            return var.equals(new FileLocalResolver(this.tree).resolveLocally(operand).getTarget());
        }

        private boolean isNullLiteral(@NotNull LighterASTNode value) {
            if (value == null) {
                NullityInferenceVisitor.$$$reportNull$$$0(2);
            }
            return value.getTokenType() == JavaElementType.LITERAL_EXPRESSION && this.tree.getChildren(value).get(0).getTokenType() == JavaTokenType.NULL_KEYWORD;
        }

        @Nullable
        NullityInferenceResult getResult() {
            if (!this.returnedCheckedVars.isEmpty()) {
                if (ContainerUtil.exists(this.returnedCheckedVars, name -> !this.assignments.contains(name))) {
                    this.hasNotNulls = true;
                } else {
                    this.hasUnknowns = true;
                }
            }
            if (this.hasNulls) {
                return new NullityInferenceResult.Predefined(Nullness.NULLABLE);
            }
            if (this.hasErrors || this.hasUnknowns || this.delegates.size() > 1) {
                return null;
            }
            if (this.delegates.size() == 1) {
                return new NullityInferenceResult.FromDelegate(ContainerUtil.newArrayList(this.delegates.get(this.delegates.keySet().iterator().next())));
            }
            if (this.hasNotNulls) {
                return new NullityInferenceResult.Predefined(Nullness.NOT_NULL);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullityInference$NullityInferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isReferenceTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNullLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

